/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.GnutellaSearchResult;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.SharedSearchResult;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.ThirdPartySearchResult;
import com.limegroup.gnutella.gui.search.XMLSearchColumn;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.Linkable;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.limewire.collection.NameValue;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableLine
extends AbstractDataLine<SearchResult>
implements Linkable {
    private final SearchTableColumns COLUMNS;
    private SearchResult RESULT;
    private List<SearchResult> _otherResults;
    private URN _sha1;
    private NamedMediaType _mediaType;
    private Set<IpPort> _alts;
    private boolean _savedFile;
    private boolean _incompleteFile;
    private boolean _downloading;
    private boolean _secure;
    private ResultSpeed _speed = null;
    private int _quality;
    private RemoteFileDesc _chatHost;
    private RemoteFileDesc _browseHost;
    private RemoteFileDesc _nonFirewalledHost;
    private LimeXMLDocument _doc;
    private EndpointHolder _location = null;
    private long _addedOn;
    private float _lastRating = -1.0f;
    private int _licenseState = -1;
    private String _licenseName = null;

    public TableLine(SearchTableColumns searchTableColumns) {
        this.COLUMNS = searchTableColumns;
    }

    @Override
    public void initialize(SearchResult searchResult) {
        super.initialize(searchResult);
        this.initilizeStart(searchResult);
        searchResult.initialize(this);
        this.initializeEnd();
    }

    private void initilizeStart(SearchResult searchResult) {
        this.RESULT = searchResult;
        this._doc = searchResult.getXMLDocument();
        this._sha1 = searchResult.getSHA1Urn();
        this._mediaType = this._doc != null ? NamedMediaType.getFromDescription(this._doc.getSchemaDescription()) : NamedMediaType.getFromExtension(this.getExtension());
        this._speed = new ResultSpeed(searchResult.getSpeed(), searchResult.isMeasuredSpeed());
        this._quality = searchResult.getQuality();
        this._secure = searchResult.getSecureStatus() == 2;
    }

    private void initializeEnd() {
        this.updateLicense();
        this.updateFileStatus();
    }

    @Override
    public boolean isLink() {
        if (this.RESULT instanceof Linkable) {
            return ((Linkable)((Object)this.RESULT)).isLink();
        }
        return this._doc != null && !"".equals(this._doc.getAction());
    }

    @Override
    public String getLinkUrl() {
        if (this.RESULT instanceof Linkable) {
            return ((Linkable)((Object)this.RESULT)).getLinkUrl();
        }
        return this._doc.getAction();
    }

    void addNewResult(SearchResult searchResult, MetadataModel metadataModel) {
        Object object;
        Object object2;
        Object object3;
        URN uRN = this.RESULT.getSHA1Urn();
        URN uRN2 = searchResult.getSHA1Urn();
        if (uRN == null ? !$assertionsDisabled && uRN2 != null : !$assertionsDisabled && !uRN.equals(uRN2)) {
            throw new AssertionError();
        }
        if (this._otherResults == null) {
            this._otherResults = new LinkedList<SearchResult>();
        }
        this._otherResults.add(searchResult);
        this._lastRating = -1.0f;
        if (searchResult instanceof GnutellaSearchResult) {
            object3 = (GnutellaSearchResult)searchResult;
            object2 = ((GnutellaSearchResult)object3).getRemoteFileDesc();
            object = ((GnutellaSearchResult)object3).getAlts();
            if (object != null && !object.isEmpty()) {
                if (this._alts == null) {
                    this._alts = new IpPortSet();
                }
                this._alts.addAll((Collection<IpPort>)object);
                ((GnutellaSearchResult)object3).clearAlts();
                this._location.addHosts((Set)object);
            }
            this._location.addHost(object2.getHost(), object2.getPort());
        }
        if (this._speed.compareTo((ResultSpeed)(object3 = new ResultSpeed(searchResult.getSpeed(), searchResult.isMeasuredSpeed()))) < 0) {
            if (metadataModel != null) {
                metadataModel.updateProperty(Selector.PropertyType.SPEED.getKey(), this._speed, object3, this);
            }
            this._speed = object3;
        }
        this._quality = Math.max(searchResult.getQuality(), this._quality);
        this._secure |= searchResult.getSecureStatus() == 2;
        if (searchResult instanceof GnutellaSearchResult) {
            object2 = (GnutellaSearchResult)searchResult;
            object = ((GnutellaSearchResult)object2).getRemoteFileDesc();
            if (object.getCreationTime() > 0L) {
                this._addedOn = Math.min(this._addedOn, object.getCreationTime());
            }
            if (this._chatHost == null && object.isChatEnabled()) {
                this._chatHost = object;
            }
            if (this._browseHost == null && object.isBrowseHostEnabled()) {
                this._browseHost = object;
            }
            if (this._nonFirewalledHost == null && !object.isFirewalled()) {
                this._nonFirewalledHost = object;
            }
        }
        if (searchResult.getCreationTime() > 0L) {
            this._addedOn = Math.min(this._addedOn, searchResult.getCreationTime());
        }
        this.updateXMLDocument(searchResult.getXMLDocument(), metadataModel);
    }

    final boolean isThirdPartyResult() {
        return this.RESULT instanceof ThirdPartySearchResult;
    }

    private void updateXMLDocument(LimeXMLDocument limeXMLDocument, MetadataModel metadataModel) {
        Set<String> set;
        if (limeXMLDocument == null) {
            return;
        }
        if (this._doc == null) {
            this._doc = limeXMLDocument;
            this.updateLicense();
            if (metadataModel != null) {
                this._mediaType = NamedMediaType.getFromDescription(this._doc.getSchemaDescription());
                metadataModel.addNewDocument(this._doc, this);
            }
            return;
        }
        if (!this._doc.getSchemaURI().equals(limeXMLDocument.getSchemaURI())) {
            return;
        }
        Set<String> set2 = this._doc.getNameSet();
        if (set2.containsAll(set = limeXMLDocument.getNameSet())) {
            return;
        }
        set = new HashSet<String>(set);
        set.removeAll(set2);
        HashMap<String, String> hashMap = new HashMap<String, String>(set2.size() + set.size());
        for (Map.Entry<String, String> object : this._doc.getNameValueSet()) {
            hashMap.put(object.getKey(), object.getValue());
        }
        LimeXMLSchema limeXMLSchema = this._doc.getSchema();
        for (SchemaFieldInfo schemaFieldInfo : limeXMLSchema.getCanonicalizedFields()) {
            String string = schemaFieldInfo.getCanonicalizedFieldName();
            if (!set.contains(string)) continue;
            String string2 = limeXMLDocument.getValue(string);
            if (metadataModel == null) continue;
            metadataModel.addField(schemaFieldInfo, string, string2, this);
        }
        this._doc = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(hashMap.entrySet(), this._doc.getSchemaURI());
        this.updateLicense();
    }

    private void updateFileStatus() {
        if (this.RESULT instanceof SharedSearchResult) {
            SharedSearchResult sharedSearchResult = (SharedSearchResult)this.RESULT;
            if (sharedSearchResult.getFileDesc() instanceof IncompleteFileDesc) {
                this._incompleteFile = true;
            } else {
                this._savedFile = true;
            }
        } else {
            if (this._sha1 != null) {
                this._savedFile = GuiCoreMediator.getFileManager().isUrnShared(this._sha1);
                this._incompleteFile = GuiCoreMediator.getDownloadManager().isIncomplete(this._sha1);
            } else {
                this._savedFile = false;
                this._incompleteFile = false;
            }
            if (!this._savedFile) {
                this._savedFile = GuiCoreMediator.getSavedFileManager().isSaved(this._sha1, this.getFilename());
            }
        }
    }

    @Override
    public void update() {
        this.updateLicense();
        this._lastRating = -1.0f;
    }

    private void updateLicense() {
        if (this._doc != null && this._sha1 != null) {
            String string = this._doc.getLicenseString();
            LicenseFactory licenseFactory = this._doc.getLicenseFactory();
            if (string != null) {
                this._licenseState = licenseFactory.isVerifiedAndValid(this._sha1, string) ? 2 : 0;
                this._licenseName = licenseFactory.getLicenseName(string);
            }
        }
    }

    boolean isSecure() {
        return this._secure;
    }

    boolean isLicenseAvailable() {
        return this._licenseState != -1;
    }

    License getLicense() {
        if (this._doc != null && this._sha1 != null) {
            return this._doc.getLicense();
        }
        return null;
    }

    public URN getSHA1Urn() {
        return this._sha1;
    }

    ResultSpeed getSpeed() {
        return this._speed;
    }

    Date getAddedOn() {
        if (this._addedOn > 0L) {
            return new Date(this._addedOn);
        }
        return null;
    }

    int getQuality() {
        boolean bl = this.RESULT.isDownloading();
        if (bl != this._downloading) {
            this.updateFileStatus();
        }
        this._downloading = bl;
        if (this._savedFile) {
            return 1002;
        }
        if (bl) {
            return 1001;
        }
        if (this._incompleteFile) {
            return 1000;
        }
        if (this._secure) {
            return 999;
        }
        if (!this.isThirdPartyResult() && SearchSettings.ENABLE_SPAM_FILTER.getValue() && SpamFilter.isAboveSpamThreshold(this)) {
            return 1003;
        }
        return this._quality;
    }

    public NamedMediaType getNamedMediaType() {
        return this._mediaType;
    }

    LimeXMLDocument getXMLDocument() {
        return this._doc;
    }

    EndpointHolder getLocation() {
        return this._location;
    }

    List<SearchResult> getOtherResults() {
        if (this._otherResults == null) {
            return Collections.emptyList();
        }
        return this._otherResults;
    }

    Set<? extends IpPort> getAlts() {
        if (this._alts == null) {
            return Collections.emptySet();
        }
        return this._alts;
    }

    int getLocationCount() {
        return this._location == null ? 1 : this._location.numLocations();
    }

    String getLicenseName() {
        return this._licenseName;
    }

    boolean isChatEnabled() {
        return this._chatHost != null;
    }

    boolean isBrowseHostEnabled() {
        return this._browseHost != null;
    }

    boolean hasNonFirewalledRFD() {
        return this._nonFirewalledHost != null;
    }

    boolean isLaunchable() {
        return this._doc != null && this._doc.getAction() != null && !"".equals(this._doc.getAction());
    }

    String getFilenameNoExtension() {
        return this.RESULT.getFilenameNoExtension();
    }

    IconAndNameHolder getIconAndExtension() {
        String string = this.getExtension();
        return new IconAndNameHolderImpl(this.getIcon(), string);
    }

    Icon getIcon() {
        if (this.isThirdPartyResult()) {
            return new Icon(){
                private final Icon icon = GUIMediator.getThemeImage("external_link");

                public int getIconHeight() {
                    return this.icon.getIconHeight();
                }

                public int getIconWidth() {
                    return this.icon.getIconWidth();
                }

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                    this.icon.paintIcon(component, graphics, n, n2);
                }

                public String toString() {
                    return null;
                }
            };
        }
        String string = this.getExtension();
        return IconManager.instance().getIconForExtension(string);
    }

    String getExtension() {
        return this.RESULT.getExtension();
    }

    public String getFilename() {
        return this.RESULT.getFileName();
    }

    public long getSize() {
        return this.RESULT.getSize();
    }

    String getVendor() {
        return this.RESULT.getVendor();
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        return this.COLUMNS.getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return SearchTableColumns.COLUMN_COUNT;
    }

    @Override
    public boolean isDynamic(int n) {
        return false;
    }

    @Override
    public boolean isClippable(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 4;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return new Integer(this.getQuality());
            }
            case 1: {
                int n2 = this.getLocationCount();
                if (n2 == 1) {
                    return null;
                }
                return new Integer(n2);
            }
            case 3: {
                return this.getIcon();
            }
            case 4: {
                return new ResultNameHolder(this);
            }
            case 5: {
                return this.getExtension();
            }
            case 6: {
                return new SizeHolder(this.getSize());
            }
            case 7: {
                return this.getSpeed();
            }
            case 8: {
                return this.isChatEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return this.getLocation();
            }
            case 10: {
                return this.RESULT.getVendor();
            }
            case 11: {
                return this.getAddedOn();
            }
            case 2: {
                return new NameValue.ComparableByName<Integer>(this._licenseName, new Integer(this._licenseState));
            }
            case 12: {
                return new Float(this.getSpamRating());
            }
        }
        if (this._doc == null || n == -1) {
            return null;
        }
        XMLSearchColumn xMLSearchColumn = (XMLSearchColumn)this.getColumn(n);
        return new XMLValue(this._doc.getValue(xMLSearchColumn.getId()), xMLSearchColumn.getSchemaFieldInfo());
    }

    @Override
    public String[] getToolTipArray(int n) {
        if (n == 3 && OSUtils.isWindows()) {
            String string;
            Icon icon = this.getIcon();
            if (icon != null && (string = icon.toString()) != null) {
                return new String[]{icon.toString()};
            }
            return null;
        }
        if (n == 9 && this.getLocationCount() > 1) {
            StringBuilder stringBuilder = new StringBuilder(69);
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator<String> iterator = this._location.getHosts().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                if (n2 == 3) {
                    n2 = 0;
                    linkedList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder(69);
                }
                stringBuilder.append(iterator.next());
                if (iterator.hasNext()) {
                    stringBuilder.append(", ");
                } else {
                    linkedList.add(stringBuilder.toString());
                }
                ++n2;
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.isSecure()) {
            linkedList.add(I18n.tr("This is a secure result. No information in this result has been tampered."));
            linkedList.add("");
        }
        if (this.isLink()) {
            linkedList.add(this.getLinkUrl());
            linkedList.add("");
        }
        if (this._doc != null) {
            linkedList.addAll(XMLUtils.getDisplayList(this._doc));
        }
        if (!linkedList.isEmpty()) {
            linkedList.add(0, this.getFilenameNoExtension());
            return linkedList.toArray(new String[linkedList.size()]);
        }
        return null;
    }

    public final boolean isSameKindAs(TableLine tableLine) {
        return this.getSearchResult().getClass().equals(tableLine.getSearchResult().getClass());
    }

    String getHostname() {
        return this.RESULT.getHost();
    }

    RemoteFileDesc[] getAllRemoteFileDescs() {
        if (this.isThirdPartyResult()) {
            return new RemoteFileDesc[0];
        }
        GnutellaSearchResult gnutellaSearchResult = (GnutellaSearchResult)this.RESULT;
        int n = this.getOtherResults().size() + 1;
        RemoteFileDesc[] remoteFileDescArray = new RemoteFileDesc[n];
        remoteFileDescArray[0] = gnutellaSearchResult.getRemoteFileDesc();
        int n2 = 1;
        Iterator<SearchResult> iterator = this.getOtherResults().iterator();
        while (iterator.hasNext()) {
            remoteFileDescArray[n2] = ((GnutellaSearchResult)iterator.next()).getRemoteFileDesc();
            ++n2;
        }
        return remoteFileDescArray;
    }

    void doChat() {
        if (this._chatHost != null && this._chatHost.getHost() != null && this._chatHost.getPort() != -1) {
            GUIMediator.createChat(this._chatHost.getHost(), this._chatHost.getPort());
        }
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RESULT instanceof GnutellaSearchResult ? ((GnutellaSearchResult)this.RESULT).getRemoteFileDesc() : null;
    }

    float getSpamRating() {
        if (this._lastRating == -1.0f) {
            this._lastRating = this.RESULT.getSpamRating();
            int n = 1;
            if (this._otherResults != null) {
                for (SearchResult searchResult : this._otherResults) {
                    if (!(searchResult instanceof GnutellaSearchResult)) continue;
                    ++n;
                    this._lastRating += ((GnutellaSearchResult)searchResult).getRemoteFileDesc().getSpamRating();
                }
            }
            this._lastRating /= (float)n;
        }
        return this._lastRating;
    }

    RemoteFileDesc getBrowseHostEnabledRFD() {
        return this._browseHost;
    }

    RemoteFileDesc getNonFirewalledRFD() {
        return this._nonFirewalledHost;
    }

    RemoteFileDesc getChatEnabledRFD() {
        return this._chatHost;
    }

    public final SearchResult getSearchResult() {
        return this.RESULT;
    }

    public final Color getEvenRowColor() {
        return this.RESULT.getEvenRowColor();
    }

    public final Color getOddRowColor() {
        return this.RESULT.getOddRowColor();
    }

    public final void takeAction(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        this.RESULT.takeAction(tableLine, gUID, file, string, bl, searchInformation);
    }

    final void setChatHost(RemoteFileDesc remoteFileDesc) {
        this._chatHost = remoteFileDesc;
    }

    final void setAddedOn(long l) {
        this._addedOn = l;
    }

    final void setNonFirewalledHost(RemoteFileDesc remoteFileDesc) {
        this._nonFirewalledHost = remoteFileDesc;
    }

    final void setBrowseHost(RemoteFileDesc remoteFileDesc) {
        this._browseHost = remoteFileDesc;
    }

    final void createEndpointHolder(String string, int n, boolean bl) {
        this._location = new EndpointHolder(string, n, bl);
    }

    final Set<IpPort> getAltIpPortSet() {
        if (this._alts == null) {
            this._alts = new IpPortSet();
        }
        return this._alts;
    }
}

