/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.settings.SearchSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableRowFilter
extends ResultPanelModel {
    private final TableLineFilter FILTER;
    private TableLineFilter junkFilter = AllowFilter.instance();
    protected final List<TableLine> HIDDEN;
    private int _numSources;

    public TableRowFilter(TableLineFilter tableLineFilter) {
        if (tableLineFilter == null) {
            throw new NullPointerException("null filter");
        }
        this.FILTER = tableLineFilter;
        this.HIDDEN = new ArrayList<TableLine>(150);
        this._numSources = 0;
    }

    public boolean isSorted() {
        return super.isSorted() || SearchSettings.moveJunkToBottom();
    }

    public int getFilteredSources() {
        return super.getTotalSources();
    }

    public int getTotalSources() {
        return this.getFilteredSources() + this._numSources;
    }

    public int addNewResult(TableLine tableLine, SearchResult searchResult) {
        if (SearchSettings.hideJunk()) {
            int n = super.addNewResult(tableLine, searchResult);
            if (!this.junkFilter.allow(tableLine)) {
                int n2 = this.getRow(tableLine);
                this.remove(n2);
                this.METADATA.remove(tableLine);
                this._numSources += tableLine.getLocationCount();
                return 0;
            }
            return n;
        }
        if (SearchSettings.moveJunkToBottom()) {
            boolean bl = this.junkFilter.allow(tableLine);
            int n = super.addNewResult(tableLine, searchResult);
            if (bl && !this.junkFilter.allow(tableLine)) {
                int n3 = this.getRow(tableLine);
                this.remove(n3);
                return super.add(tableLine, this.getSortedPosition(tableLine));
            }
            return n;
        }
        return super.addNewResult(tableLine, searchResult);
    }

    public int add(TableLine tableLine, int n) {
        boolean bl = this.junkFilter.allow(tableLine);
        boolean bl2 = this.allow(tableLine);
        if (bl || !SearchSettings.hideJunk()) {
            if (bl2) {
                return super.add(tableLine, n);
            }
            this.HIDDEN.add(tableLine);
            if (this._useMetadata) {
                this.METADATA.addNew(tableLine);
            }
            this._numSources += tableLine.getLocationCount();
        } else {
            this._numSources += tableLine.getLocationCount();
        }
        return -1;
    }

    protected void simpleClear() {
        this._numSources = 0;
        this.HIDDEN.clear();
        super.simpleClear();
    }

    void filtersChanged() {
        this.rebuild();
        this.fireTableDataChanged();
    }

    void setJunkFilter(TableLineFilter tableLineFilter) {
        this.junkFilter = tableLineFilter != null ? tableLineFilter : AllowFilter.instance();
    }

    private boolean allow(TableLine tableLine) {
        return this.FILTER.allow(tableLine);
    }

    private void rebuild() {
        int n;
        ArrayList arrayList = new ArrayList(this._list);
        ArrayList<TableLine> arrayList2 = new ArrayList<TableLine>(this.HIDDEN);
        this.simpleClear();
        this.setUseMetadata(false);
        if (this.isSorted()) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.addSorted((DataLine)arrayList.get(n));
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                this.add((TableLine)arrayList.get(n));
            }
        }
        HashMap<URN, TableLine> hashMap = new HashMap<URN, TableLine>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            TableLine tableLine = (TableLine)arrayList2.get(i);
            SearchResult searchResult = (SearchResult)tableLine.getInitializeObject();
            URN uRN = searchResult.getSHA1Urn();
            TableLine tableLine2 = (TableLine)hashMap.get(uRN);
            if (tableLine2 == null) {
                hashMap.put(uRN, tableLine);
                continue;
            }
            tableLine2.addNewResult(searchResult, this.METADATA);
        }
        if (this.isSorted()) {
            for (TableLine tableLine : hashMap.values()) {
                this.addSorted(tableLine);
            }
        } else {
            for (TableLine tableLine : hashMap.values()) {
                this.add(tableLine);
            }
        }
        this.setUseMetadata(true);
    }
}

