/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.sharing;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.StringArraySetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileTypeSharingPanelManager {
    private static final int MAX_EXT_LENGTH = 15;
    public static final String TITLE = I18nMarker.marktr("Sharing Extensions");
    public static final String LABEL = I18nMarker.marktr("Select the types of files on your computer that you wish to share with FrostWire.");
    public static final String URL = "http://www.frostwire.com/?id=faq#sea1";
    private Component parent = null;
    private JPanel mainContainer;
    private CheckBoxList<NamedMediaType> sidePanel;
    private CardLayout mediaLayout;
    private JPanel currentPanel;
    private CheckBoxList<String> customPanel;
    private Set<String> customUnchecked;
    private Map<NamedMediaType, CheckBoxList<String>> panels;
    private final ExtensionProvider extensionProvider = new ExtensionProvider();
    public static final String CUSTOM = "__Custom$";
    public static final String OTHER = "_Other$";
    public static final String CUSTOM_NAME = I18nMarker.marktr("My Extensions");
    public static final String OTHER_NAME = I18nMarker.marktr("Other");
    private static final NamedMediaType otherMedia = new NamedMediaType(new MediaType(OTHER_NAME, "_Other$", null), null);
    private static final NamedMediaType customMedia = new NamedMediaType(new MediaType("CUSTOM_NAME", "__Custom$", null), null);
    private JCheckBox disableSensitive;
    private boolean migrate;
    private Set<NamedMediaType> mediaKeys;
    private Set<NamedMediaType> mediaUnchecked;
    private NamedMediaType customKey = customMedia;
    private NamedMediaType currentKey;
    private String originalExtensions;

    public FileTypeSharingPanelManager(Component component) {
        this();
        this.parent = component;
    }

    public FileTypeSharingPanelManager() {
        this.customUnchecked = new HashSet<String>();
        this.mainContainer = new JPanel(new BorderLayout());
        this.mediaLayout = new CardLayout();
        this.currentPanel = new JPanel(this.mediaLayout);
    }

    private void switchPanel(NamedMediaType namedMediaType) {
        this.currentKey = namedMediaType;
        this.mediaLayout.show(this.currentPanel, namedMediaType.toString());
        this.sidePanel.setItemSelected(namedMediaType);
    }

    public void addCustomExt(String string) {
        Set<String> set = this.customPanel.getElements();
        set.add(string);
        this.customUnchecked = this.customPanel.getRawUncheckedElementsAsSet();
        this.customPanel.setElements(set, this.customUnchecked);
        this.switchPanel(this.customKey);
        this.sidePanel.setItemSelected(this.customKey);
    }

    private void revert() {
        NamedMediaType namedMediaType = this.currentKey;
        SharingSettings.EXTENSIONS_TO_SHARE.revertToDefault();
        SharingSettings.EXTENSIONS_LIST_CUSTOM.revertToDefault();
        SharingSettings.EXTENSIONS_LIST_UNSHARED.revertToDefault();
        SharingSettings.DISABLE_SENSITIVE.revertToDefault();
        this.initCore();
        this.buildUI();
        this.switchPanel(namedMediaType);
        this.sidePanel.setItemSelected(namedMediaType);
    }

    private void refreshSidePanel() {
        this.sidePanel.update();
    }

    private void setPanelEnabled(NamedMediaType namedMediaType, boolean bl) {
        this.panels.get(namedMediaType).setEnabled(bl);
    }

    public Container getContainer() {
        return this.mainContainer;
    }

    void initCore() {
        Object object;
        Set<Object> set;
        Object object2;
        String[] stringArray;
        this.customUnchecked.clear();
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray = SharingSettings.getDefaultExtensions();
        this.migrate = SharingSettings.EXTENSIONS_MIGRATE.getValue();
        if (this.migrate) {
            stringArray = StringArraySetting.decode(SharingSettings.EXTENSIONS_TO_SHARE.getValue().toLowerCase());
            for (int i = 0; i < stringArray.length; ++i) {
                if (FileTypeSharingPanelManager.contains(objectArray, stringArray[i])) continue;
                hashSet.add(stringArray[i]);
            }
        } else {
            int n;
            String[] stringArray2 = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_CUSTOM.getValue().toLowerCase());
            object2 = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_UNSHARED.getValue().toLowerCase());
            set = new HashSet<Object>();
            object = new HashSet<Object>();
            for (n = 0; n < objectArray.length; ++n) {
                set.add(objectArray[n]);
                object.add(objectArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n].length() <= 0 || FileTypeSharingPanelManager.contains(objectArray, stringArray2[n])) continue;
                hashSet.add(stringArray2[n]);
            }
            for (n = 0; n < ((Object)object2).length; ++n) {
                set.remove(object2[n]);
                if (!hashSet.contains(object2[n])) continue;
                this.customUnchecked.add((String)object2[n]);
            }
            objectArray = object.toArray(new String[object.size()]);
            stringArray = new String[set.size()];
            stringArray = set.toArray(stringArray);
        }
        Map<NamedMediaType, List<String>> map = FileTypeSharingPanelManager.createExtensionsMap(stringArray, hashSet);
        object2 = FileTypeSharingPanelManager.createExtensionsMap((String[])objectArray, hashSet);
        this.mediaKeys = new TreeSet<NamedMediaType>();
        set = map.keySet();
        if (set != null) {
            this.mediaKeys.addAll(set);
        }
        if ((set = object2.keySet()) != null) {
            this.mediaKeys.addAll(set);
        }
        this.panels = new LinkedHashMap<NamedMediaType, CheckBoxList<String>>();
        this.mediaUnchecked = new HashSet<NamedMediaType>();
        this.currentKey = null;
        object = new PanelsCheckChangeListener(this);
        for (NamedMediaType namedMediaType : this.mediaKeys) {
            if (this.currentKey == null) {
                this.currentKey = namedMediaType;
            }
            List<String> list = map.get(namedMediaType);
            List list2 = (List)object2.get(namedMediaType);
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet treeSet2 = new TreeSet();
            if (list2 != null) {
                treeSet.addAll(list2);
                treeSet2.addAll(list2);
            }
            if (list != null) {
                treeSet.addAll(list);
                treeSet2.removeAll(list);
            }
            CheckBoxList<String> checkBoxList = new CheckBoxList<String>(treeSet, treeSet2, this.extensionProvider, 1);
            checkBoxList.setDisabledTooltip(I18n.tr("To allow selection enable sharing of sensitive types."));
            checkBoxList.setCheckChangeListener((CheckBoxList.CheckBoxListCheckChangeListener)object);
            if (((Object)treeSet).equals(treeSet2)) {
                checkBoxList.setEnabled(false);
                this.mediaUnchecked.add(namedMediaType);
            }
            this.panels.put(namedMediaType, checkBoxList);
        }
        this.insertNewCustomPanel(hashSet);
        this.originalExtensions = this.getExtensions();
    }

    public void buildUI() {
        this.mainContainer.removeAll();
        this.currentPanel.removeAll();
        for (NamedMediaType namedMediaType : this.mediaKeys) {
            this.currentPanel.add((Component)this.panels.get(namedMediaType), namedMediaType.toString());
        }
        this.sidePanel = new CheckBoxList<NamedMediaType>(this.mediaKeys, this.mediaUnchecked, new MediaProvider(), new MediaExtrasProvider(this.panels), 0);
        this.sidePanel.setPreferredSize(new Dimension(150, 0));
        this.sidePanel.setSelectionListener(new SideSelectListener(this));
        this.sidePanel.setCheckChangeListener(new CheckChangeListener(this));
        this.sidePanel.setItemSelected(this.currentKey);
        JSplitPane jSplitPane = new JSplitPane(1, this.sidePanel, this.currentPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(180);
        this.mainContainer.add((Component)jSplitPane, "Center");
        this.addBottomPanel();
        this.shareProtect(!SharingSettings.DISABLE_SENSITIVE.getValue());
        this.mainContainer.validate();
    }

    private void shareProtect(boolean bl) {
        String[] stringArray = SharingSettings.getDefaultDisabledExtensions();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        for (CheckBoxList checkBoxList : this.panels.values()) {
            checkBoxList.setItemsEnabled(hashSet, bl);
        }
        this.refreshSidePanel();
    }

    private static Map<NamedMediaType, List<String>> createExtensionsMap(String[] stringArray, Set<String> set) {
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<NamedMediaType, List<String>> linkedHashMap = new LinkedHashMap<NamedMediaType, List<String>>();
        for (String string : stringArray) {
            List list;
            NamedMediaType namedMediaType = NamedMediaType.getFromExtension(string);
            if (namedMediaType == null) {
                namedMediaType = otherMedia;
            }
            if (!linkedHashMap.containsKey(namedMediaType)) {
                linkedHashMap.put(namedMediaType, new ArrayList(8));
            }
            if ((list = (List)linkedHashMap.get(namedMediaType)).contains(string) || set != null && set.contains(string)) continue;
            list.add(string);
        }
        return linkedHashMap;
    }

    private String getExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        for (CheckBoxList<String> checkBoxList : this.panels.values()) {
            hashSet.addAll(checkBoxList.getCheckedElements());
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        return StringArraySetting.encode(stringArray);
    }

    private String getUncheckedExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        for (CheckBoxList<String> checkBoxList : this.panels.values()) {
            hashSet.addAll(checkBoxList.getUncheckedElements());
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        return StringArraySetting.encode(stringArray);
    }

    private static boolean contains(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExt(String string) {
        if (string == null) {
            return false;
        }
        String string2 = I18n.tr("The extension name was not valid, could not add.");
        if (string.length() == 0 || string.length() > 15) {
            JOptionPane.showMessageDialog(this.parent, string2);
            return false;
        }
        if (FileTypeSharingPanelManager.contains(SharingSettings.getDefaultExtensions(), string)) {
            CheckBoxList<String> checkBoxList;
            NamedMediaType namedMediaType = NamedMediaType.getFromExtension(string);
            if (namedMediaType == null) {
                namedMediaType = otherMedia;
            }
            if ((checkBoxList = this.panels.get(namedMediaType)) == null) {
                JOptionPane.showMessageDialog(this.parent, string2);
                return false;
            }
            this.switchPanel(namedMediaType);
            checkBoxList.setItemChecked(string);
            this.sidePanel.setItemSelected(namedMediaType);
            return false;
        }
        if (this.customPanel.getElements().contains(string)) {
            CheckBoxList<String> checkBoxList = this.panels.get(this.customKey);
            if (checkBoxList == null) {
                JOptionPane.showMessageDialog(this.parent, string2);
                return false;
            }
            this.switchPanel(this.customKey);
            checkBoxList.setItemChecked(string);
            this.sidePanel.setItemSelected(this.customKey);
            return false;
        }
        return true;
    }

    private void addBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.disableSensitive = new JCheckBox(I18n.tr("Do Not Share Sensitive File Types"));
        this.disableSensitive.setToolTipText(I18n.tr("This stops FrostWire from sharing certain files that may contain sensitive information."));
        this.disableSensitive.setSelected(SharingSettings.DISABLE_SENSITIVE.getValue());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.disableSensitive.setBorder(null);
        jPanel2.add(this.disableSensitive);
        jPanel.add((Component)new JButton(new RestoreAction()), "West");
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)new JButton(new AddExtAction()), "East");
        this.disableSensitive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileTypeSharingPanelManager.this.shareProtect(!((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        this.mainContainer.add((Component)jPanel, "South");
    }

    private void insertNewCustomPanel(Set<String> set) {
        this.customPanel = new CheckBoxList<String>(set, this.customUnchecked, this.extensionProvider, 1);
        this.customPanel.setRemovable(true);
        this.customPanel.setCheckChangeListener(new PanelsCheckChangeListener(this));
        this.currentPanel.add(this.customPanel, this.customKey.toString());
        this.mediaKeys.add(this.customKey);
        this.panels.put(this.customKey, this.customPanel);
    }

    public void initOptions() {
        this.initCore();
        this.buildUI();
    }

    public boolean applyOptions() {
        String string = this.getExtensions();
        SharingSettings.EXTENSIONS_TO_SHARE.setValue(string);
        GuiCoreMediator.getFileManager().loadSettings();
        SharingSettings.DISABLE_SENSITIVE.setValue(this.disableSensitive == null || this.disableSensitive.isSelected());
        String[] stringArray = new String[this.customPanel.getElements().size()];
        stringArray = this.customPanel.getElements().toArray(stringArray);
        SharingSettings.EXTENSIONS_MIGRATE.setValue(false);
        SharingSettings.EXTENSIONS_LIST_UNSHARED.setValue(this.getUncheckedExtensions());
        SharingSettings.EXTENSIONS_LIST_CUSTOM.setValue(StringArraySetting.encode(stringArray));
        return false;
    }

    public boolean isDirty() {
        return !this.originalExtensions.equals(this.getExtensions()) || !this.disableSensitive.isSelected() == SharingSettings.DISABLE_SENSITIVE.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MediaExtrasProvider
    implements CheckBoxList.ExtrasProvider<NamedMediaType> {
        Map<NamedMediaType, CheckBoxList<String>> panels;

        public MediaExtrasProvider(Map<NamedMediaType, CheckBoxList<String>> map) {
            this.panels = map;
        }

        @Override
        public boolean isSeparated(NamedMediaType namedMediaType) {
            return customMedia.equals(namedMediaType);
        }

        @Override
        public String getComment(NamedMediaType namedMediaType) {
            CheckBoxList<String> checkBoxList = this.panels.get(namedMediaType);
            if (checkBoxList == null) {
                return "(0)";
            }
            return "(" + checkBoxList.getCheckedElements().size() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MediaProvider
    implements CheckBoxList.TextProvider<NamedMediaType> {
        private MediaProvider() {
        }

        @Override
        public String getText(NamedMediaType namedMediaType) {
            if (namedMediaType == null) {
                throw new IllegalArgumentException();
            }
            if (FileTypeSharingPanelManager.CUSTOM.equals(namedMediaType.getName())) {
                return CUSTOM_NAME;
            }
            if (FileTypeSharingPanelManager.OTHER.equals(namedMediaType.getName())) {
                return OTHER_NAME;
            }
            return namedMediaType.getName();
        }

        @Override
        public String getToolTipText(NamedMediaType namedMediaType) {
            if (namedMediaType == null) {
                throw new IllegalArgumentException();
            }
            if (namedMediaType.getName() == null) {
                return null;
            }
            if (FileTypeSharingPanelManager.CUSTOM.equals(namedMediaType.getName())) {
                return I18n.tr("File types you added to share.");
            }
            if (FileTypeSharingPanelManager.OTHER.equals(namedMediaType.getName())) {
                return I18n.tr("Other types of files.");
            }
            return namedMediaType.getMediaType().getDescriptionKey();
        }

        @Override
        public Icon getIcon(NamedMediaType namedMediaType) {
            ImageIcon imageIcon;
            if (namedMediaType == null) {
                throw new IllegalArgumentException();
            }
            if (FileTypeSharingPanelManager.CUSTOM.equals(namedMediaType.getName())) {
                ImageIcon imageIcon2 = GUIMediator.getThemeImage("custom");
                if (imageIcon2 != null) {
                    return imageIcon2;
                }
            } else if (FileTypeSharingPanelManager.OTHER.equals(namedMediaType.getName()) && (imageIcon = GUIMediator.getThemeImage("lime")) != null) {
                return imageIcon;
            }
            return namedMediaType.getIcon();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionProvider
    implements CheckBoxList.TextProvider<String> {
        private Set<String> mediaNames = new HashSet<String>();

        public ExtensionProvider() {
            for (NamedMediaType namedMediaType : NamedMediaType.getAllNamedMediaTypes()) {
                this.mediaNames.add(namedMediaType.getName());
            }
        }

        @Override
        public String getText(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            return string;
        }

        @Override
        public String getToolTipText(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            Icon icon = IconManager.instance().getIconForExtension(string);
            if (icon == null) {
                return null;
            }
            if (icon.toString().indexOf("@") > -1) {
                return null;
            }
            if (this.mediaNames.contains(icon.toString())) {
                return null;
            }
            return icon.toString();
        }

        @Override
        public Icon getIcon(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            Icon icon = IconManager.instance().getIconForExtension(string);
            return icon != null ? icon : new GUIUtils.EmptyIcon(string, 16, 16);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PanelsCheckChangeListener
    implements CheckBoxList.CheckBoxListCheckChangeListener<NamedMediaType> {
        private FileTypeSharingPanelManager parent;

        public PanelsCheckChangeListener(FileTypeSharingPanelManager fileTypeSharingPanelManager) {
            this.parent = fileTypeSharingPanelManager;
        }

        @Override
        public void valueChanged(CheckBoxList.CheckBoxListCheckChangeEvent<NamedMediaType> checkBoxListCheckChangeEvent) {
            this.parent.refreshSidePanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckChangeListener
    implements CheckBoxList.CheckBoxListCheckChangeListener<NamedMediaType> {
        private FileTypeSharingPanelManager parent;

        public CheckChangeListener(FileTypeSharingPanelManager fileTypeSharingPanelManager) {
            this.parent = fileTypeSharingPanelManager;
        }

        @Override
        public void valueChanged(CheckBoxList.CheckBoxListCheckChangeEvent<NamedMediaType> checkBoxListCheckChangeEvent) {
            this.parent.setPanelEnabled(checkBoxListCheckChangeEvent.getSelected(), checkBoxListCheckChangeEvent.getChecked());
            this.parent.refreshSidePanel();
        }
    }

    private static class SideSelectListener
    implements CheckBoxList.CheckBoxListSelectionListener {
        private FileTypeSharingPanelManager parent;

        public SideSelectListener(FileTypeSharingPanelManager fileTypeSharingPanelManager) {
            this.parent = fileTypeSharingPanelManager;
        }

        public void valueChanged(CheckBoxList.CheckBoxListSelectionEvent checkBoxListSelectionEvent) {
            this.parent.switchPanel((NamedMediaType)checkBoxListSelectionEvent.getSelected());
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            this.putValue("Name", I18n.tr("Restore Defaults"));
            this.putValue("ShortDescription", I18n.tr("Share the Default File Extensions"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(FileTypeSharingPanelManager.this.parent, new Object[]{new MultiLineLabel(I18n.tr("This options clears any extension sharing changes you made and sets FrostWire's extension sharing preferences to the original preferences. Do you wish to continue?"), 300)}, I18n.tr("Extension Sharing Settings"), 0);
            if (n == 0) {
                FileTypeSharingPanelManager.this.revert();
            }
        }
    }

    private class AddExtAction
    extends AbstractAction {
        public AddExtAction() {
            this.putValue("Name", I18n.tr("Add New Extension"));
            this.putValue("ShortDescription", I18n.tr("Add a New Extension to My Extensions"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(FileTypeSharingPanelManager.this.parent, I18n.tr("Enter the extension pattern:"), I18n.tr("Extension Sharing Settings"), -1);
            if (string == null) {
                return;
            }
            string = string.toLowerCase();
            if (FileTypeSharingPanelManager.this.checkExt(string)) {
                FileTypeSharingPanelManager.this.addCustomExt(string);
            }
        }
    }
}

