/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.SortArrowIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class AquaSortArrowIcon
extends SortArrowIcon {
    private static final Icon DESCENDING_ICON = new AquaSortArrowIcon(1);
    private static final Icon ASCENDING_ICON = new AquaSortArrowIcon(2);
    private static final Color ARROW_GRAY = new Color(89, 93, 97);
    private static final int BLUR_FIX = 1;

    public static Icon getAscendingIcon() {
        return ASCENDING_ICON;
    }

    public static Icon getDescendingIcon() {
        return DESCENDING_ICON;
    }

    public AquaSortArrowIcon(int n) {
        super(n);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.direction == 0) {
            return;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null || !lookAndFeel.isNativeLookAndFeel()) {
            super.paintIcon(component, graphics, n, n2);
            return;
        }
        Dimension dimension = component.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f = 7.0f;
        float f2 = 7.0f;
        float f3 = f / 2.0f;
        float f4 = dimension.width - 12;
        float f5 = ((float)dimension.height - f2 - 1.0f) / 2.0f;
        graphics2D.setColor(ARROW_GRAY);
        GeneralPath generalPath = new GeneralPath();
        switch (this.direction) {
            case 1: {
                generalPath.moveTo(f4, f5);
                generalPath.lineTo(f4 + f, f5);
                generalPath.lineTo(f4 + f3, f5 + f2);
                generalPath.closePath();
                break;
            }
            case 2: {
                generalPath.moveTo(f4, f5 + f2);
                generalPath.lineTo(f4 + f, f5 + f2);
                generalPath.lineTo(f4 + f3, f5);
                generalPath.closePath();
            }
        }
        graphics2D.fill(generalPath);
    }
}

