/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ProgressBarRenderer
extends LimeJProgressBar
implements TableCellRenderer,
ThemeObserver {
    private Border _selectedBorder;
    private Border _unselectedBorder;
    private Map<Color, Border> borders = new HashMap<Color, Border>();

    public ProgressBarRenderer() {
        ThemeMediator.addThemeObserver(this);
        this.setStringPainted(true);
        Font font = this.getFont();
        Font font2 = font == null || font.getName() == null ? new Font("Dialog", 1, 9) : new Font(font.getName(), 1, 9);
        this.setFont(font2);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._unselectedBorder = this.getCachedOrNewBorder(color);
        if (this._unselectedBorder != null) {
            this.setBorder(this._unselectedBorder);
        }
    }

    public void updateTheme() {
        this._selectedBorder = null;
        this._unselectedBorder = null;
        this.borders.clear();
    }

    public Border getCachedOrNewBorder(Color color) {
        if (color == null) {
            return null;
        }
        if (this.borders == null) {
            return null;
        }
        Border border = this.borders.get(color);
        if (border == null) {
            border = BorderFactory.createMatteBorder(2, 5, 2, 5, color);
            this.borders.put(color, border);
        }
        return border;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setValue(Math.min(100, this.getBarStatus(object)));
        this.setString(this.getDescription(object));
        if (this._selectedBorder == null && this._unselectedBorder == null) {
            Color color = jTable.getSelectionBackground();
            Color color2 = ((LimeJTable)jTable).getBackgroundForRow(n);
            this._selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, color);
            this._unselectedBorder = this.getCachedOrNewBorder(color2);
        }
        if (bl) {
            this.setBorder(this._selectedBorder);
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBorder(this._unselectedBorder);
        }
        return this;
    }

    protected String getDescription(Object object) {
        return Integer.toString(this.getBarStatus(object)) + " %";
    }

    protected int getBarStatus(Object object) {
        return object == null ? 0 : (Integer)object;
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        JComponent jComponent = (JComponent)container;
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && jComponent.isOpaque();
        return !bl && super.isOpaque();
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

