/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ChatHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.gui.upload.UploadProgressBarRenderer;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.swing.Icon;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UploadDataLine
extends AbstractDataLine<Uploader> {
    private static final String CONNECTING_STATE = I18n.tr("Connecting");
    private static final String UPLOADING_STATE = I18n.tr("Uploading");
    private static final String LIMIT_REACHED_STATE = I18n.tr("Upload Limit Reached");
    private static final String FREELOADER_STATE = I18n.tr("Freeloader Uploading");
    private static final String INTERRUPTED_STATE = I18n.tr("Transfer Interrupted");
    private static final String COMPLETE_STATE = I18n.tr("Complete");
    private static final String FILE_NOT_FOUND_STATE = I18n.tr("File Not Found");
    private static final String QUEUED_STATE = I18n.tr("Queued at");
    private static final String UNAVAILABLE_RANGE_STATE = I18n.tr("Range Unavailable");
    private static final String MALFORMED_REQUEST_STATE = I18n.tr("Malformed Request");
    private static final String BANNED_GREEDY_STATE = I18n.tr("Banned Greedy Servent");
    private static final String HASH_TREE_STATE = I18n.tr("Uploading Hash Tree");
    private static final String SUSPENDED_STATE = I18n.tr("Suspended");
    private static final String AWAITING_REQUESTS_STATE = I18n.tr("Awaiting Requests");
    private static final String AVERAGE_BANDWIDTH = I18n.tr("Average Bandwidth");
    private static final String STARTED_ON = I18n.tr("Started On");
    private static final String FINISHED_ON = I18n.tr("Finished On");
    private static final String TIME_SPENT = I18n.tr("Time Spent");
    private String _fileName;
    private String _status;
    private String _hostName;
    private String _userAgent;
    private UploadProgressBarRenderer.UploadProgressBarData _progress;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private double _speed;
    private int _timeLeft;
    private boolean _persistConnection;
    private long _startTime;
    private long _endTime = -1L;
    private Uploader.UploadStatus _state;
    static final int FILE_INDEX = 0;
    private static final LimeTableColumn FILE_COLUMN = new LimeTableColumn(0, "UPLOAD_TABLE_STRING_NAME", I18n.tr("Name"), 160, true, IconAndNameHolder.class);
    static final int HOST_INDEX = 1;
    private static final LimeTableColumn HOST_COLUMN = new LimeTableColumn(1, "UPLOAD_TABLE_STRING_HOST", I18n.tr("Host"), 70, true, String.class);
    static final int SIZE_INDEX = 2;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(2, "UPLOAD_TABLE_STRING_SIZE", I18n.tr("Size"), 25, true, SizeHolder.class);
    static final int STATUS_INDEX = 3;
    private static final LimeTableColumn STATUS_COLUMN = new LimeTableColumn(3, "UPLOAD_TABLE_STRING_STATUS", I18n.tr("Status"), 100, true, String.class);
    static final int CHAT_INDEX = 4;
    private static final LimeTableColumn CHAT_COLUMN = new LimeTableColumn(4, "UPLOAD_TABLE_STRING_CHAT", I18n.tr("Chat"), 10, true, ChatHolder.class);
    static final int PROGRESS_INDEX = 5;
    private static final LimeTableColumn PROGRESS_COLUMN = new LimeTableColumn(5, "UPLOAD_TABLE_STRING_PROGRESS", I18n.tr("Progress"), 25, true, ProgressBarHolder.class);
    static final int SPEED_INDEX = 6;
    private static final LimeTableColumn SPEED_COLUMN = new LimeTableColumn(6, "UPLOAD_TABLE_STRING_SPEED", I18n.tr("Speed"), 15, true, SpeedRenderer.class);
    static final int TIME_INDEX = 7;
    private static final LimeTableColumn TIME_COLUMN = new LimeTableColumn(7, "UPLOAD_TABLE_STRING_TIME_REMAINING", I18n.tr("Time"), 15, true, TimeRemainingHolder.class);
    static final int USER_AGENT_INDEX = 8;
    private static final LimeTableColumn USER_AGENT_COLUMN = new LimeTableColumn(8, "UPLOAD_TABLE_STRING_USER_AGENT", I18n.tr("Vendor/Version"), 70, true, String.class);
    static final int NUMBER_OF_COLUMNS = 9;

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public void initialize(Uploader uploader) {
        boolean bl = this.initializer == null;
        super.initialize(uploader);
        if (bl) {
            this._startTime = System.currentTimeMillis();
            this._chatEnabled = ((Uploader)this.initializer).isChatEnabled();
            this._browseEnabled = ((Uploader)this.initializer).isBrowseHostEnabled();
            this._fileName = ((Uploader)this.initializer).getFileName();
            this._hostName = ((Uploader)this.initializer).getHost();
            this._userAgent = ((Uploader)this.initializer).getUserAgent();
            if (this._hostName == "") {
                this._hostName = I18n.tr("Swarm for {0}", this._fileName);
            }
            if (this._userAgent == "") {
                this._userAgent = I18n.tr("Multiple");
            }
        }
        this._endTime = -1L;
        this._status = "";
        this._persistConnection = false;
        this.update();
    }

    @Override
    public void cleanup() {
        if (!this._persistConnection) {
            ((Uploader)this.initializer).stop();
        }
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                FileDesc fileDesc;
                Icon icon = ((Uploader)this.initializer).getCustomIconDescriptor() == "" ? GUIMediator.getThemeImage("bittorrent_upload") : ((fileDesc = ((Uploader)this.initializer).getFileDesc()) == null ? null : IconManager.instance().getIconForFile(fileDesc.getFile()));
                return new IconAndNameHolderImpl(icon, this._fileName);
            }
            case 1: {
                return this._hostName;
            }
            case 2: {
                return new SizeHolder(this.getLength());
            }
            case 3: {
                return this._status;
            }
            case 4: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this._progress;
            }
            case 6: {
                return new Double(this._speed);
            }
            case 7: {
                return new TimeRemainingHolder(this._timeLeft);
            }
            case 8: {
                return this._userAgent;
            }
        }
        return null;
    }

    @Override
    public LimeTableColumn getColumn(int n) {
        switch (n) {
            case 0: {
                return FILE_COLUMN;
            }
            case 1: {
                return HOST_COLUMN;
            }
            case 2: {
                return SIZE_COLUMN;
            }
            case 3: {
                return STATUS_COLUMN;
            }
            case 4: {
                return CHAT_COLUMN;
            }
            case 5: {
                return PROGRESS_COLUMN;
            }
            case 6: {
                return SPEED_COLUMN;
            }
            case 7: {
                return TIME_COLUMN;
            }
            case 8: {
                return USER_AGENT_COLUMN;
            }
        }
        return null;
    }

    @Override
    public boolean isClippable(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }

    @Override
    public String[] getToolTipArray(int n) {
        String[] stringArray = new String[this._endTime != -1L ? 5 : 4];
        String string = AVERAGE_BANDWIDTH + ": " + GUIUtils.rate2speed(((Uploader)this.initializer).getAverageBandwidth());
        stringArray[0] = STARTED_ON + " " + GUIUtils.msec2DateTime(this._startTime);
        if (this._endTime != -1L) {
            stringArray[1] = FINISHED_ON + " " + GUIUtils.msec2DateTime(this._endTime);
            stringArray[2] = TIME_SPENT + ": " + CommonUtils.seconds2time((int)((this._endTime - this._startTime) / 1000L));
            stringArray[3] = "";
            stringArray[4] = string;
        } else {
            stringArray[1] = TIME_SPENT + ": " + CommonUtils.seconds2time((int)((System.currentTimeMillis() - this._startTime) / 1000L));
            stringArray[2] = "";
            stringArray[3] = string;
        }
        return stringArray;
    }

    @Override
    public boolean isDynamic(int n) {
        switch (n) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    long getLength() {
        return this.initializer == null ? 0L : ((Uploader)this.initializer).getFileSize();
    }

    boolean containsUploader(Uploader uploader) {
        return ((Uploader)this.initializer).equals(uploader);
    }

    Uploader getUploader() {
        return (Uploader)this.initializer;
    }

    String getHost() {
        return ((Uploader)this.initializer).getHost();
    }

    int getFileIndex() {
        return ((Uploader)this.initializer).getIndex();
    }

    Uploader.UploadStatus getState() {
        return this._state;
    }

    double getSpeed() {
        return this._speed;
    }

    boolean isCompleted() {
        return this._state == Uploader.UploadStatus.COMPLETE;
    }

    boolean isChatEnabled() {
        return this._chatEnabled;
    }

    boolean isBrowseEnabled() {
        return this._browseEnabled;
    }

    @Override
    public void update() {
        Uploader.UploadStatus uploadStatus = ((Uploader)this.initializer).getState();
        Uploader.UploadStatus uploadStatus2 = ((Uploader)this.initializer).getLastTransferState();
        if (uploadStatus == Uploader.UploadStatus.COMPLETE && this._endTime == -1L || uploadStatus == Uploader.UploadStatus.CONNECTING && ((Uploader)this.initializer).getTotalAmountUploaded() != 0L) {
            uploadStatus = uploadStatus2;
        }
        if (uploadStatus == Uploader.UploadStatus.COMPLETE && uploadStatus2 != Uploader.UploadStatus.UPLOADING && uploadStatus2 != Uploader.UploadStatus.QUEUED && uploadStatus2 != Uploader.UploadStatus.THEX_REQUEST) {
            uploadStatus = uploadStatus2;
        }
        this._speed = -1.0;
        this._timeLeft = 0;
        this.updateStatus(uploadStatus);
    }

    private void updateStatus(Uploader.UploadStatus uploadStatus) {
        this._state = uploadStatus;
        switch (this._state) {
            case CONNECTING: {
                this._status = CONNECTING_STATE;
                break;
            }
            case FREELOADER: {
                this._status = FREELOADER_STATE;
                break;
            }
            case COMPLETE: {
                if (this._status != COMPLETE_STATE) {
                    this.setProgress();
                }
                this._status = COMPLETE_STATE;
                break;
            }
            case UNAVAILABLE_RANGE: {
                this._status = UNAVAILABLE_RANGE_STATE;
                break;
            }
            case MALFORMED_REQUEST: {
                this._status = MALFORMED_REQUEST_STATE;
                break;
            }
            case SUSPENDED: {
                this._status = SUSPENDED_STATE;
                break;
            }
            case WAITING_REQUESTS: {
                this._status = AWAITING_REQUESTS_STATE;
                break;
            }
            case LIMIT_REACHED: {
                this._status = LIMIT_REACHED_STATE;
                break;
            }
            case INTERRUPTED: {
                if (this._status != INTERRUPTED_STATE) {
                    this.setProgress();
                }
                this._status = INTERRUPTED_STATE;
                break;
            }
            case FILE_NOT_FOUND: {
                this._status = FILE_NOT_FOUND_STATE;
                break;
            }
            case THEX_REQUEST: {
                this._status = HASH_TREE_STATE;
                this.setProgress();
                this.setSpeedAndTimeLeft();
                break;
            }
            case UPLOADING: {
                this._status = UPLOADING_STATE;
                this.setProgress();
                this.setSpeedAndTimeLeft();
                break;
            }
            case BROWSE_HOST: {
                throw new IllegalStateException("Browse Host status in GUI Upload view");
            }
            case QUEUED: {
                this._status = QUEUED_STATE + " (" + (((Uploader)this.initializer).getQueuePosition() + 1) + ")";
                this.setProgress();
                break;
            }
            case BANNED_GREEDY: {
                this._status = BANNED_GREEDY_STATE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status " + (Object)((Object)uploadStatus) + " of uploader");
            }
        }
    }

    private void setSpeedAndTimeLeft() {
        try {
            this._speed = ((Uploader)this.initializer).getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            this._speed = 0.0;
        }
        if (this._speed > 0.0) {
            double d = ((double)this.getLength() - (double)((Uploader)this.initializer).getTotalAmountUploaded()) / 1024.0;
            this._timeLeft = Math.max(0, (int)(d / this._speed));
        }
    }

    private void setProgress() {
        if (this._progress == null) {
            this._progress = new UploadProgressBarRenderer.UploadProgressBarData(this.getHost() == "");
        }
        this._progress.totalSize = ((Uploader)this.initializer).getFileSize();
        this._progress.totalUploaded = ((Uploader)this.initializer).getTotalAmountUploaded();
    }

    boolean isInactive() {
        return this._endTime != -1L;
    }

    boolean isUploading() {
        return this._state == Uploader.UploadStatus.UPLOADING;
    }

    void setPersistConnection(boolean bl) {
        this._persistConnection = bl;
    }

    void setEndTime(long l) {
        this._endTime = l;
        this.initializer = new FakeUploader((Uploader)this.initializer);
        super.initialize(this.initializer);
    }

    private static class FakeUploader
    implements Uploader {
        private final int idx;
        private final long tUp;
        private final int gPort;
        private final float mBand;
        private final float aBand;
        private final String name;
        private final long size;
        private final String host;
        private final Uploader.UploadStatus state;
        private final String agent;
        private final boolean chat;
        private final boolean browse;
        private final Uploader.UploadStatus lastState;
        private final FileDesc fd;
        private final String iconDesc;
        private final boolean tlsCapable;
        private final String addr;
        private final InetAddress inetAddr;
        private final int port;
        private final InetSocketAddress inetSocketAddr;
        private final URN urn;
        private final float sRatio;
        private final int nCons;
        private final File file;

        FakeUploader(Uploader uploader) {
            float f;
            this.idx = uploader.getIndex();
            this.tUp = uploader.getTotalAmountUploaded();
            this.gPort = uploader.getGnutellaPort();
            try {
                f = uploader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f = 0.0f;
            }
            this.mBand = f;
            this.aBand = uploader.getAverageBandwidth();
            this.name = uploader.getFileName();
            this.size = uploader.getFileSize();
            this.host = uploader.getHost();
            this.state = uploader.getState();
            this.chat = uploader.isChatEnabled();
            this.browse = uploader.isBrowseHostEnabled();
            this.agent = uploader.getUserAgent();
            this.lastState = uploader.getLastTransferState();
            this.fd = uploader.getFileDesc();
            this.iconDesc = uploader.getCustomIconDescriptor();
            this.tlsCapable = uploader.isTLSCapable();
            this.addr = uploader.getAddress();
            this.inetAddr = uploader.getInetAddress();
            this.port = uploader.getPort();
            this.inetSocketAddr = uploader.getInetSocketAddress();
            this.urn = uploader.getUrn();
            this.sRatio = uploader.getSeedRatio();
            this.nCons = uploader.getNumUploadConnections();
            this.file = uploader.getFile();
        }

        public void stop() {
        }

        public String getFileName() {
            return this.name;
        }

        public long getFileSize() {
            return this.size;
        }

        public FileDesc getFileDesc() {
            return this.fd;
        }

        public int getIndex() {
            return this.idx;
        }

        public long amountUploaded() {
            return 0L;
        }

        public long getTotalAmountUploaded() {
            return this.tUp;
        }

        public String getHost() {
            return this.host;
        }

        public Uploader.UploadStatus getState() {
            return this.state;
        }

        public Uploader.UploadStatus getLastTransferState() {
            return this.lastState;
        }

        public boolean isChatEnabled() {
            return this.chat;
        }

        public boolean isBrowseHostEnabled() {
            return this.browse;
        }

        public int getGnutellaPort() {
            return this.gPort;
        }

        public String getUserAgent() {
            return this.agent;
        }

        public int getQueuePosition() {
            return -1;
        }

        public boolean isInactive() {
            return true;
        }

        public void measureBandwidth() {
        }

        public float getMeasuredBandwidth() {
            return this.mBand;
        }

        public float getAverageBandwidth() {
            return this.aBand;
        }

        public String getCustomIconDescriptor() {
            return this.iconDesc;
        }

        public UploadType getUploadType() {
            return UploadType.SHARED_FILE;
        }

        public boolean isTLSCapable() {
            return this.tlsCapable;
        }

        public String getAddress() {
            return this.addr;
        }

        public InetAddress getInetAddress() {
            return this.inetAddr;
        }

        public int getPort() {
            return this.port;
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.inetSocketAddr;
        }

        public float getSeedRatio() {
            return this.sRatio;
        }

        public int getNumUploadConnections() {
            return this.nCons;
        }

        public URN getUrn() {
            return this.urn;
        }

        public File getFile() {
            return this.file;
        }
    }
}

