/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;

public class UploadProgressBarRenderer
extends ProgressBarRenderer {
    protected int getBarStatus(Object object) {
        if (object == null) {
            return 0;
        }
        UploadProgressBarData uploadProgressBarData = (UploadProgressBarData)object;
        return (int)(uploadProgressBarData.totalUploaded * 100L / uploadProgressBarData.totalSize);
    }

    protected String getDescription(Object object) {
        if (object == null) {
            return "0 %";
        }
        UploadProgressBarData uploadProgressBarData = (UploadProgressBarData)object;
        if (uploadProgressBarData.totalSize == 0L) {
            return "0 %";
        }
        int n = this.getBarStatus(object);
        if (!uploadProgressBarData.isBittorrent || n <= 100) {
            return Integer.toString(Math.min(100, n)) + " %";
        }
        return I18n.tr("Seeding") + "(" + GUIUtils.toUnitbytes(uploadProgressBarData.totalUploaded - uploadProgressBarData.totalSize) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UploadProgressBarData
    implements Comparable<UploadProgressBarData> {
        public long totalUploaded;
        public long totalSize;
        public final boolean isBittorrent;

        public UploadProgressBarData(boolean bl) {
            this.isBittorrent = bl;
        }

        @Override
        public int compareTo(UploadProgressBarData uploadProgressBarData) {
            float f = (float)this.totalUploaded / (float)this.totalSize;
            float f2 = (float)uploadProgressBarData.totalUploaded / (float)uploadProgressBarData.totalSize;
            if (f > f2) {
                return 1;
            }
            if (f < f2) {
                return -1;
            }
            return 0;
        }
    }
}

