/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.util;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.QuestionsHandler;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Cursor;
import java.io.File;

public class GUILauncher {
    public static void launch(LaunchableProvider[] launchableProviderArray) {
        boolean bl = false;
        GUIMediator.instance().setFrameCursor(Cursor.getPredefinedCursor(3));
        for (LaunchableProvider launchableProvider : launchableProviderArray) {
            File file;
            final Downloader downloader = launchableProvider.getDownloader();
            if (downloader == null) {
                file = launchableProvider.getFile();
                if (file == null) continue;
                bl = GUIUtils.launchOrEnqueueFile(file, bl);
                continue;
            }
            if (downloader.getState() == Downloader.DownloadStatus.INVALID) {
                GUIMediator.openURL("http://www.frostwire.com/?id=faq#Downloading");
                continue;
            }
            file = (File)Worker.post(new Job(){

                public Object run() {
                    return downloader.getDownloadFragment();
                }
            });
            if (file != null && downloader.getState() == Downloader.DownloadStatus.COMPLETE) {
                bl = GUIUtils.launchOrEnqueueFile(file, false);
                continue;
            }
            if (file != null) {
                bl = GUIUtils.launchOneTimeFile(file);
                continue;
            }
            GUIMediator.instance().setFrameCursor(Cursor.getDefaultCursor());
            GUIMediator.showMessage(I18n.tr("There is nothing to preview for file {0}.", downloader.getSaveFile().getName()), QuestionsHandler.NO_PREVIEW_REPORT);
            GUIMediator.instance().setFrameCursor(Cursor.getPredefinedCursor(3));
        }
        GUIMediator.instance().setFrameCursor(Cursor.getDefaultCursor());
    }

    public static interface LaunchableProvider {
        public Downloader getDownloader();

        public File getFile();
    }
}

