/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.wizard;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.wizard.WizardPage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.limewire.util.OSUtils;

public class Wizard {
    public static final int DIALOG_WIDTH = 540;
    public static final int DIALOG_HEIGHT = 360;
    protected JDialog dialog;
    private WizardPagePanel pageContainer = new WizardPagePanel();
    private WizardPage currentPage;
    public static final int ACTION_PREVIOUS = 1;
    public static final int ACTION_NEXT = 2;
    public static final int ACTION_FINISH = 4;
    public static final int ACTION_CANCEL = 8;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private CancelAction cancelAction = new CancelAction();
    private AbstractAction[] actions = new AbstractAction[]{this.previousAction, this.nextAction, this.finishAction, this.cancelAction};

    public void addPage(WizardPage wizardPage) {
        wizardPage.setWizard(this);
        wizardPage.createPage();
        this.pageContainer.add(wizardPage);
    }

    public JDialog createDialog(Frame frame) {
        this.dialog = new JDialog(frame);
        this.dialog.setModal(true);
        if (!OSUtils.isUnix()) {
            this.dialog.setResizable(false);
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Wizard.this.performCancel();
            }
        });
        GUIUtils.addHideAction((JComponent)this.dialog.getContentPane());
        Container container = this.dialog.getContentPane();
        BoxLayout boxLayout = new BoxLayout(container, 1);
        container.setLayout(boxLayout);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(1, 1, 0, 0));
        BoxLayout boxLayout2 = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout2);
        jPanel.add(this.pageContainer);
        jPanel.add(Box.createVerticalStrut(10));
        ButtonRow buttonRow = new ButtonRow(this.actions, 0, 12);
        buttonRow.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add(buttonRow);
        if (this.pageContainer.getFirst() != null) {
            this.show(this.pageContainer.getFirst());
        }
        container.add(jPanel);
        int n = Math.max(((JComponent)container).getPreferredSize().width, 540);
        int n2 = Math.max(((JComponent)container).getPreferredSize().height, 360);
        ((JComponent)container).setPreferredSize(new Dimension(n, n2));
        this.dialog.pack();
        return this.dialog;
    }

    public void enableActions(int n) {
        this.previousAction.setEnabled((n & 1) != 0);
        this.nextAction.setEnabled((n & 2) != 0);
        this.finishAction.setEnabled((n & 4) != 0);
        this.cancelAction.setEnabled((n & 8) != 0);
    }

    public int getEnabledActions() {
        int n = 0;
        if (this.previousAction.isEnabled()) {
            n |= 1;
        }
        if (this.nextAction.isEnabled()) {
            n |= 2;
        }
        if (this.finishAction.isEnabled()) {
            n |= 4;
        }
        if (this.cancelAction.isEnabled()) {
            n |= 8;
        }
        return n;
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        return this.pageContainer.getNext(wizardPage);
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        return this.pageContainer.getPrevious(wizardPage);
    }

    public void performNext() {
        WizardPage wizardPage = this.currentPage.getNext();
        this.show(wizardPage);
    }

    public void performPrevious() {
        WizardPage wizardPage = this.currentPage.getPrevious();
        this.show(wizardPage);
    }

    public void performCancel() {
        this.dialog.dispose();
    }

    public void performFinish() {
        this.dialog.dispose();
    }

    private void show(WizardPage wizardPage) {
        this.pageContainer.show(wizardPage.getKey());
        this.currentPage = wizardPage;
        wizardPage.pageShown();
    }

    public void updateButtons() {
        if (this.currentPage == null) {
            this.finishAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.previousAction.setEnabled(false);
        } else {
            boolean bl = this.currentPage.isPageComplete();
            boolean bl2 = this.currentPage.canFlipToNextPage();
            this.finishAction.setEnabled(bl && !bl2);
            this.nextAction.setEnabled(bl && bl2);
            this.previousAction.setEnabled(this.currentPage.getPrevious() != null);
        }
    }

    private class WizardPagePanel
    extends JPanel {
        private final CardLayout CARD_LAYOUT = new CardLayout();

        WizardPagePanel() {
            this.setLayout(this.CARD_LAYOUT);
        }

        void add(WizardPage wizardPage) {
            this.add((Component)wizardPage, wizardPage.getKey());
        }

        public WizardPage getFirst() {
            if (this.getComponentCount() > 0) {
                return (WizardPage)this.getComponent(0);
            }
            return null;
        }

        public WizardPage getLast() {
            if (this.getComponentCount() > 0) {
                return (WizardPage)this.getComponent(this.getComponentCount() - 1);
            }
            return null;
        }

        public WizardPage getNext(WizardPage wizardPage) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != wizardPage || i >= componentArray.length - 1) continue;
                return (WizardPage)componentArray[i + 1];
            }
            return null;
        }

        public WizardPage getPrevious(WizardPage wizardPage) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != wizardPage || i <= 0) continue;
                return (WizardPage)componentArray[i - 1];
            }
            return null;
        }

        void show(String string) {
            this.CARD_LAYOUT.show(this, string);
        }
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            this.putValue("Name", I18n.tr("Finish"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.performFinish();
        }
    }

    private class PreviousAction
    extends AbstractAction {
        public PreviousAction() {
            this.putValue("Name", I18n.tr("<< Back"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.performPrevious();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            this.putValue("Name", I18n.tr("Next >>"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.performNext();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.performCancel();
        }
    }
}

