/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.wizard;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.wizard.Status;
import com.limegroup.gnutella.gui.wizard.Wizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public abstract class WizardPage
extends JPanel {
    private String key;
    private String titleKey;
    private String descriptionKey;
    private String url;
    private String urlLabelKey;
    protected Wizard wizard;
    protected JLabel statusLabel;

    public WizardPage(String string, String string2, String string3) {
        this.key = string;
        this.titleKey = string2;
        this.descriptionKey = string3;
    }

    public WizardPage(String string, String string2) {
        this(string, string, string2);
    }

    protected void createPage() {
        Object object;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel = new JLabel(I18n.tr(this.titleKey));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jLabel.setFont(new Font("Dialog", 1, 16));
        jLabel.setForeground(Color.black);
        jLabel.setOpaque(false);
        jPanel2.add((Component)jLabel, "North");
        MultiLineLabel multiLineLabel = new MultiLineLabel(I18n.tr(this.descriptionKey));
        multiLineLabel.setOpaque(false);
        multiLineLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        multiLineLabel.setForeground(Color.black);
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(0));
        jPanel2.add((Component)multiLineLabel, "Center");
        if (this.url != null) {
            object = this.urlLabelKey != null ? I18n.tr(this.urlLabelKey) : this.url;
            URLLabel uRLLabel = new URLLabel(this.url, (String)object);
            uRLLabel.setOpaque(false);
            uRLLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            uRLLabel.setForeground(Color.black);
            uRLLabel.setOpaque(false);
            jPanel2.add((Component)uRLLabel, "South");
        }
        object = new JPanel();
        ((JComponent)object).setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)object, "Center");
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.add((Component)this.statusLabel, "South");
        this.createPageContent((JPanel)object);
        this.revalidate();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNext() != null;
    }

    protected abstract void createPageContent(JPanel var1);

    public String getKey() {
        return this.key;
    }

    public WizardPage getNext() {
        return this.wizard != null ? this.wizard.getNextPage(this) : null;
    }

    public WizardPage getPrevious() {
        return this.wizard != null ? this.wizard.getPreviousPage(this) : null;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public abstract boolean isPageComplete();

    public void pageShown() {
        this.validateInput();
        this.wizard.updateButtons();
    }

    public void setSatusMessage(String string) {
        this.setStatusMessage(Status.Severity.ERROR, string);
    }

    public void setStatusMessage(Status.Severity severity, String string) {
        if (string == null) {
            this.statusLabel.setText(" ");
            this.statusLabel.setIcon(null);
        } else {
            this.statusLabel.setText(string);
            if (severity == Status.Severity.ERROR) {
                this.statusLabel.setIcon(GUIMediator.getThemeImage("stop_small"));
            } else if (severity == Status.Severity.INFO) {
                this.statusLabel.setIcon(GUIMediator.getThemeImage("annotate_small"));
            } else {
                this.statusLabel.setIcon(null);
            }
        }
    }

    public void validateInput() {
    }

    public void updateStatus(Status ... statusArray) {
        if (statusArray == null || statusArray.length == 0) {
            this.setSatusMessage(null);
        } else {
            this.setStatusMessage(statusArray[0].getSeverity(), statusArray[0].getMessage());
        }
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public void setURL(String string, String string2) {
        this.url = string;
        this.urlLabelKey = string2;
    }

    private static class MultiLineLabel
    extends JTextArea {
        public MultiLineLabel(String string) {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setHighlighter(null);
            LookAndFeel.installBorder(this, "Label.border");
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
            this.setSelectedTextColor(UIManager.getColor("Label.foreground"));
            this.setText(string);
        }

        public MultiLineLabel() {
            this(" ");
        }
    }
}

