/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.xml.editor.MetaDataEventListener;
import com.limegroup.gnutella.licenses.PublishedCCLicense;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class CCRDFOuptut
implements MetaDataEventListener {
    private final String CCPUBLISHER_TITLE = I18n.tr("License RDF Output");
    private static final int DIALOG_WIDTH = 480;
    private static final int DIALOG_HEIGHT = 360;
    private final JLabel RDF_OUTPUT_LABEL = new JLabel("<html>" + I18n.tr("In order to publish your file, please insert the following code in your verification page at:") + "</html>");
    private final JTextArea RDF_OUTPUT = new JTextArea(6, 20);
    private CopyAction copyAction = new CopyAction();
    private FinishAction finishAction = new FinishAction();
    private JDialog dialog;
    private final FileDesc _fd;
    private final String _holder;
    private final String _title;
    private final String _year;
    private final String _description;
    private final String _url;
    private final int _type;
    private boolean _isEventHandled;

    public CCRDFOuptut(FileDesc fileDesc, String string, String string2, String string3, String string4, String string5, int n) {
        this._fd = fileDesc;
        this._holder = string;
        this._title = string2;
        this._year = string3;
        this._description = string4;
        this._url = string5;
        this._type = n;
    }

    public void handleFileEvent(FileManagerEvent fileManagerEvent) {
        if (!fileManagerEvent.isChangeEvent() || fileManagerEvent.getFileDescs() == null || fileManagerEvent.getFileDescs().length == 0) {
            return;
        }
        if (this._fd.equals(fileManagerEvent.getFileDescs()[0])) {
            this.showDialog(fileManagerEvent.getFileDescs()[1]);
        }
    }

    public void metaDataUnchanged(FileDesc fileDesc) {
        this.showDialog(fileDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDialog(final FileDesc fileDesc) {
        CCRDFOuptut cCRDFOuptut = this;
        synchronized (cCRDFOuptut) {
            if (this._isEventHandled) {
                return;
            }
            this._isEventHandled = true;
        }
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                CCRDFOuptut.this.initDialog();
                String string = PublishedCCLicense.getRDFRepresentation(CCRDFOuptut.this._holder, CCRDFOuptut.this._title, CCRDFOuptut.this._year, CCRDFOuptut.this._description, fileDesc.getSHA1Urn().httpStringValue(), CCRDFOuptut.this._type);
                CCRDFOuptut.this.RDF_OUTPUT.setText(string);
                CCRDFOuptut.this.RDF_OUTPUT.setCaretPosition(0);
                CCRDFOuptut.this.dialog.setLocationRelativeTo(MessageService.getParentComponent());
                CCRDFOuptut.this.dialog.setDefaultCloseOperation(2);
                GUIUtils.addHideAction(CCRDFOuptut.this.dialog);
                CCRDFOuptut.this.dialog.setVisible(true);
            }
        });
    }

    private void initDialog() {
        this.dialog = new JDialog((Frame)GUIMediator.getAppFrame(), true);
        this.dialog.setTitle(this.CCPUBLISHER_TITLE);
        BoxPanel boxPanel = new BoxPanel();
        boxPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        boxPanel.addLeft(this.RDF_OUTPUT_LABEL);
        boxPanel.addLineGap();
        URLLabel uRLLabel = new URLLabel(this._url);
        boxPanel.addLeft(uRLLabel);
        boxPanel.addLineGap();
        this.RDF_OUTPUT.setEditable(false);
        this.RDF_OUTPUT.setLineWrap(true);
        boxPanel.add(new JScrollPane(this.RDF_OUTPUT, 20, 30));
        boxPanel.addVerticalComponentGap();
        JButton jButton = new JButton(this.copyAction);
        boxPanel.addCenter(jButton);
        boxPanel.addLineGap();
        ButtonRow buttonRow = new ButtonRow(new Action[]{this.finishAction}, 0, 12);
        boxPanel.add(buttonRow);
        this.dialog.setContentPane(boxPanel);
        this.dialog.setSize(new Dimension(480, 360));
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            this.putValue("Name", I18n.tr("Finish"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CCRDFOuptut.this.dialog.dispose();
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("Name", I18n.tr("Copy to Clipboard"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(CCRDFOuptut.this.RDF_OUTPUT.getText()), null);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }
}

