/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.xml.editor.MetaDataEventListener;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.xml.sax.SAXException;

public class MetaDataSaver {
    private FileDesc[] fds;
    private String input;
    private LimeXMLSchema schema;

    public MetaDataSaver(FileDesc[] fileDescArray, LimeXMLSchema limeXMLSchema, String string) {
        this.fds = fileDescArray;
        this.schema = limeXMLSchema;
        this.input = string;
    }

    public void saveMetaData() {
        this.saveMetaData(null);
    }

    public void saveMetaData(final MetaDataEventListener metaDataEventListener) {
        if (metaDataEventListener != null) {
            GuiCoreMediator.getFileManager().addFileEventListener(metaDataEventListener);
        }
        BackgroundExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(false);
                        }
                    });
                    MetaDataSaver.this.saveMetaDataInternal(metaDataEventListener);
                }
                catch (Throwable throwable) {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(true);
                        }
                    });
                    if (metaDataEventListener != null) {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                GuiCoreMediator.getFileManager().removeFileEventListener(metaDataEventListener);
                            }
                        };
                        GuiCoreMediator.getCoreBackgroundExecutor().schedule(runnable, 30000L, TimeUnit.MILLISECONDS);
                    }
                    throw throwable;
                }
                GUIMediator.safeInvokeAndWait(new /* invalid duplicate definition of identical inner class */);
                if (metaDataEventListener != null) {
                    Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                    GuiCoreMediator.getCoreBackgroundExecutor().schedule(runnable, 30000L, TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    private void saveMetaDataInternal(MetaDataEventListener metaDataEventListener) {
        if (this.input == null) {
            return;
        }
        if (this.fds.length == 1 && this.input.trim().length() == 0) {
            this.removeMeta(this.fds, this.schema);
            return;
        }
        LimeXMLDocument limeXMLDocument = null;
        try {
            limeXMLDocument = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(this.input);
        }
        catch (SAXException sAXException) {
            GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
            return;
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
            return;
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
            return;
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = GuiCoreMediator.getSchemaReplyCollectionMapper();
        String string = limeXMLDocument.getSchemaURI();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
        assert (limeXMLReplyCollection != null) : "Cant add doc to nonexistent collection";
        for (int i = 0; i < this.fds.length; ++i) {
            String string2 = null;
            try {
                string2 = this.fds[i].getFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    public void run() {
                        GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
                    }
                });
                continue;
            }
            LimeXMLDocument limeXMLDocument2 = this.fds[i].getXMLDocument(string);
            LimeXMLDocument limeXMLDocument3 = null;
            if (limeXMLDocument2 != null) {
                limeXMLDocument3 = MetaEditorUtil.merge(limeXMLDocument2, limeXMLDocument);
                limeXMLDocument2 = limeXMLReplyCollection.replaceDoc(this.fds[i], limeXMLDocument3);
            } else {
                limeXMLDocument3 = limeXMLDocument;
                limeXMLReplyCollection.addReply(this.fds[i], limeXMLDocument3);
            }
            if (LimeXMLUtils.isSupportedFormat(string2)) {
                final LimeXMLReplyCollection.MetaDataState metaDataState = limeXMLReplyCollection.mediaFileToDisk(this.fds[i], string2, limeXMLDocument3);
                if (metaDataState == LimeXMLReplyCollection.MetaDataState.UNCHANGED) {
                    if (metaDataEventListener == null) continue;
                    metaDataEventListener.metaDataUnchanged(this.fds[i]);
                    continue;
                }
                if (metaDataState == LimeXMLReplyCollection.MetaDataState.NORMAL) continue;
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    public void run() {
                        MetaDataSaver.this.showCommitError(metaDataState);
                    }
                });
                switch (metaDataState) {
                    case FAILED_ARTIST: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__artist__", limeXMLReplyCollection, limeXMLDocument2);
                        break;
                    }
                    case FAILED_ALBUM: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__album__", limeXMLReplyCollection, limeXMLDocument2);
                        break;
                    }
                    case FAILED_YEAR: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__year__", limeXMLReplyCollection, limeXMLDocument2);
                        break;
                    }
                    case FAILED_COMMENT: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__comments__", limeXMLReplyCollection, limeXMLDocument2);
                        break;
                    }
                    case FAILED_TRACK: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__track__", limeXMLReplyCollection, limeXMLDocument2);
                        break;
                    }
                    case FAILED_GENRE: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__genre__", limeXMLReplyCollection, limeXMLDocument2);
                    }
                }
                continue;
            }
            if (limeXMLReplyCollection.writeMapToDisk()) continue;
            GUIMediator.safeInvokeAndWait(new Runnable(){

                public void run() {
                    GUIMediator.showError(I18n.tr("Internal Error. Data could not be saved."));
                }
            });
        }
    }

    private void showCommitError(LimeXMLReplyCollection.MetaDataState metaDataState) {
        switch (metaDataState) {
            case UNCHANGED: {
                GUIMediator.showMessage(I18n.tr("Nothing to save."));
                break;
            }
            case FILE_DEFECTIVE: {
                GUIMediator.showError(I18n.tr("File not found or corrupt file. Data could not be saved"));
                break;
            }
            case RW_ERROR: {
                GUIMediator.showError(I18n.tr("Read Write Error. Data could not be saved."));
                break;
            }
            case BAD_ID3: {
                GUIMediator.showError(I18n.tr("File Corrupt. Data could not be saved."));
                break;
            }
            case FAILED_TITLE: {
                GUIMediator.showError(I18n.tr("File Corrupt. Data could not be saved."));
                break;
            }
            case FAILED_ARTIST: 
            case FAILED_ALBUM: 
            case FAILED_YEAR: 
            case FAILED_COMMENT: 
            case FAILED_TRACK: 
            case FAILED_GENRE: {
                GUIMediator.showError(I18n.tr("Incorrect format entered. Changes will not be saved."));
                break;
            }
            case HASH_FAILED: {
                GUIMediator.showError(I18n.tr("Internal Error. Data could not be saved."));
            }
        }
    }

    private void cleanUpChanges(FileDesc fileDesc, String string, LimeXMLReplyCollection limeXMLReplyCollection, LimeXMLDocument limeXMLDocument) {
        if (limeXMLDocument == null) {
            limeXMLReplyCollection.removeDoc(fileDesc);
        } else {
            limeXMLReplyCollection.replaceDoc(fileDesc, limeXMLDocument);
        }
    }

    private void removeMeta(FileDesc[] fileDescArray, LimeXMLSchema limeXMLSchema) {
        String string = limeXMLSchema.getSchemaURI();
        LimeXMLReplyCollection limeXMLReplyCollection = GuiCoreMediator.getSchemaReplyCollectionMapper().getReplyCollection(string);
        assert (limeXMLReplyCollection != null) : "Trying to remove data from a non-existent collection";
        for (int i = 0; i < fileDescArray.length; ++i) {
            if (limeXMLReplyCollection.removeDoc(fileDescArray[i])) continue;
            GUIMediator.showError(I18n.tr("Unable to remove data."));
        }
    }
}

