/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaEditorPanel
extends AbstractMetaEditorPanel {
    private Map<String, JComponent> nameToComponent;
    private Map<String, NameValue<String>> nameToUneditedField;
    protected final FileDesc[] fds;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;
    private static final Insets leftInsetsLabel = new Insets(5, 3, 0, 2);
    private static final Insets rightInsetsLabel = new Insets(5, 15, 0, 2);
    private static final Insets leftInsetsComponent = new Insets(0, 3, 2, 2);
    private static final Insets rightInsetsComponent = new Insets(0, 15, 2, 2);

    public MetaEditorPanel(FileDesc[] fileDescArray, LimeXMLSchema limeXMLSchema, LimeXMLDocument limeXMLDocument) {
        this.fds = fileDescArray;
        this.schema = limeXMLSchema;
        this.document = limeXMLDocument;
        this.nameToComponent = new HashMap<String, JComponent>();
        this.nameToUneditedField = new HashMap<String, NameValue<String>>();
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.initWithDocumentFields();
    }

    public FileDesc[] getFileDesc() {
        return this.fds;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getValue(String string) {
        return this.document != null ? this.document.getValue(string) : null;
    }

    public JLabel createLabelAndAdd(String string, int n, int n2, GridBagConstraints gridBagConstraints, Location location) {
        JLabel jLabel = new JLabel(string);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = location == Location.LEFT ? leftInsetsLabel : rightInsetsLabel;
        this.add((Component)jLabel, gridBagConstraints);
        return jLabel;
    }

    public LimeTextField createTextField(int n, int n2, int n3, int n4, GridBagConstraints gridBagConstraints, Location location, String string) {
        LimeTextField limeTextField = new LimeTextField(n);
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = location == Location.LEFT ? leftInsetsComponent : rightInsetsComponent;
        this.add((Component)limeTextField, gridBagConstraints);
        this.addComponent(string, limeTextField);
        return limeTextField;
    }

    public JComboBox createComboBox(int n, int n2, GridBagConstraints gridBagConstraints, Location location, String string) {
        JComboBox jComboBox = new JComboBox();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = location == Location.LEFT ? leftInsetsComponent : rightInsetsComponent;
        this.add(jComboBox, gridBagConstraints);
        this.addComponent(string, jComboBox);
        return jComboBox;
    }

    public void addComponent(String string, JComponent jComponent) {
        this.addComponent(string, null, jComponent);
    }

    public void addComponent(String string, JCheckBox jCheckBox, JComponent jComponent) {
        this.nameToComponent.put(string, jComponent);
    }

    public JComponent getComponent(String string) {
        return this.nameToComponent.get(string);
    }

    public Iterable<String> getComponentIterator() {
        return this.nameToComponent.keySet();
    }

    public Iterable<NameValue<String>> getUneditedFieldsIterator() {
        return this.nameToUneditedField.values();
    }

    public void reset() {
        for (String string : this.getComponentIterator()) {
            JComponent jComponent = this.getComponent(string);
            if (jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).setText("");
                continue;
            }
            if (!(jComponent instanceof JComboBox)) continue;
            ((JComboBox)jComponent).setSelectedIndex(0);
        }
    }

    protected void initFields() {
        for (String string : this.getComponentIterator()) {
            String string2 = this.getValue(string);
            JComponent jComponent = this.getComponent(string);
            if (jComponent instanceof JTextComponent) {
                if (string2 == null) continue;
                ((JTextComponent)jComponent).setText(string2);
                if (!(jComponent instanceof JTextArea)) continue;
                ((JTextArea)jComponent).setCaretPosition(0);
                continue;
            }
            if (!(jComponent instanceof JComboBox)) continue;
            JComboBox jComboBox = (JComboBox)jComponent;
            for (SchemaFieldInfo schemaFieldInfo : this.getSchema().getEnumerationFields()) {
                Object[] objectArray;
                String string3 = schemaFieldInfo.getCanonicalizedFieldName();
                if (!string3.equals(string)) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(0, new ComboBoxValue());
                this.addEnums(schemaFieldInfo.getEnumerationList(), arrayList);
                int n = 0;
                if (string2 != null && !string2.equals("") && !arrayList.contains(objectArray = new ComboBoxValue(string2))) {
                    arrayList.add(objectArray);
                }
                if (string.indexOf("__licensetype__") >= 0 && string2 != null && !string2.equals("creativecommons.org/licenses/")) {
                    arrayList.remove(new ComboBoxValue("creativecommons.org/licenses/"));
                }
                objectArray = arrayList.toArray(new Object[0]);
                Arrays.sort(objectArray);
                if (string2 != null && !string2.equals("")) {
                    n = Arrays.asList(objectArray).indexOf(new ComboBoxValue(string2));
                }
                jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
                jComboBox.setSelectedIndex(n);
            }
        }
    }

    @Override
    public List<NameValue<String>> getInput() {
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>();
        for (NameValue<String> object : this.getUneditedFieldsIterator()) {
            arrayList.add(object);
        }
        for (String string : this.getComponentIterator()) {
            String string2;
            JComboBox jComboBox;
            ComboBoxValue comboBoxValue;
            JComponent jComponent = this.getComponent(string);
            String string3 = null;
            if (jComponent instanceof JTextComponent) {
                string3 = ((JTextComponent)jComponent).getText().trim();
            } else if (jComponent instanceof JComboBox && (comboBoxValue = (ComboBoxValue)(jComboBox = (JComboBox)jComponent).getSelectedItem()) != null && (string2 = comboBoxValue.getValue()) != null) {
                string3 = string2.trim();
            }
            if (string3 == null) continue;
            arrayList.add(new NameValue<String>(string, string3));
        }
        return arrayList;
    }

    protected void addEnums(List<? extends NameValue<String>> list, List<? super ComboBoxValue> list2) {
        for (NameValue<String> nameValue : list) {
            list2.add(new ComboBoxValue(nameValue));
        }
    }

    private void initWithDocumentFields() {
        if (this.document != null) {
            for (Map.Entry<String, String> entry : this.document.getNameValueSet()) {
                String string = entry.getKey();
                this.nameToUneditedField.put(string, new NameValue<String>(string, entry.getValue()));
            }
        }
    }

    @Override
    public boolean checkInput() {
        for (String string : this.getComponentIterator()) {
            String string2;
            Object object;
            ComboBoxValue comboBoxValue;
            JComponent jComponent = this.getComponent(string);
            String string3 = null;
            if (jComponent instanceof JTextComponent) {
                string3 = ((JTextComponent)jComponent).getText().trim();
            } else if (jComponent instanceof JComboBox && (comboBoxValue = (ComboBoxValue)((JComboBox)(object = (JComboBox)jComponent)).getSelectedItem()) != null && (string2 = comboBoxValue.getValue()) != null) {
                string3 = string2.trim();
            }
            object = this.nameToUneditedField.get(string);
            if (string3 != null && string3.length() > 0 && object != null) {
                if (string3.equals(((NameValue)object).getValue())) continue;
                return true;
            }
            if (string3 != null && string3.length() > 0 && object == null) {
                return true;
            }
            if (!(string3 != null && string3.length() != 0 || object != null && ((NameValue)object).getValue() != null && ((String)((NameValue)object).getValue()).length() != 0)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        LEFT,
        RIGHT;

    }
}

