/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import org.limewire.collection.NameValue;

public abstract class MetaEditorTabbedPane
extends JTabbedPane {
    protected final FileDesc[] fds;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;

    public MetaEditorTabbedPane(FileDesc[] fileDescArray, String string) {
        this.fds = fileDescArray;
        LimeXMLDocument[] limeXMLDocumentArray = MetaEditorUtil.intersection(fileDescArray, string);
        LimeXMLSchemaRepository limeXMLSchemaRepository = GuiCoreMediator.getLimeXMLSchemaRepository();
        this.schema = limeXMLSchemaRepository.getSchema(string);
        if (this.schema == null) {
            throw new IllegalStateException("no schema!");
        }
        LimeXMLDocument limeXMLDocument = null;
        for (int i = 0; i < limeXMLDocumentArray.length; ++i) {
            if (!this.schema.equals(limeXMLDocumentArray[i].getSchema())) continue;
            limeXMLDocument = limeXMLDocumentArray[i];
            break;
        }
        this.document = limeXMLDocument;
    }

    public FileDesc[] getFileDesc() {
        return this.fds;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getInput() {
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            AbstractMetaEditorPanel abstractMetaEditorPanel;
            List<NameValue<String>> list;
            Component component = this.getComponentAt(i);
            if (!(component instanceof AbstractMetaEditorPanel) || (list = (abstractMetaEditorPanel = (AbstractMetaEditorPanel)component).getInput()) == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(arrayList, this.getSchema().getSchemaURI()).getXMLString();
    }

    public boolean hasDataChanged() {
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            AbstractMetaEditorPanel abstractMetaEditorPanel;
            Component component = this.getComponentAt(i);
            if (!(component instanceof AbstractMetaEditorPanel) || !(abstractMetaEditorPanel = (AbstractMetaEditorPanel)component).checkInput()) continue;
            return true;
        }
        return false;
    }
}

