/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaEditorUtil {
    private static final Log LOG = LogFactory.getLog(MetaEditorUtil.class);
    private static final Map<String, String> XSD_MESSAGEBUNDLE_BRIDGE = new HashMap<String, String>();
    private static final String EMPTY_VALUE;

    private MetaEditorUtil() {
    }

    public static boolean contains(String string) {
        return XSD_MESSAGEBUNDLE_BRIDGE.containsKey(string);
    }

    public static String getStringResource(String string) {
        String string2 = XSD_MESSAGEBUNDLE_BRIDGE.get(string);
        assert (string2 != null) : "Unknown resourceKey: " + string;
        return I18n.tr(string2);
    }

    public static String getKind(File file) {
        String string = file.getName();
        if (LimeXMLUtils.isMP3File(string)) {
            return I18n.tr("MPEG-1 Audio Layer 3");
        }
        if (LimeXMLUtils.isM4AFile(string)) {
            return I18n.tr("MPEG-4 Audio");
        }
        if (LimeXMLUtils.isOGGFile(string)) {
            return I18n.tr("Ogg Vorbis");
        }
        return null;
    }

    public static LimeXMLDocument[] intersection(FileDesc[] fileDescArray, String string) {
        Object object;
        Set<Map.Entry<String, String>> set;
        if (string != null) {
            string = string.toLowerCase(Locale.US);
        }
        HashMap hashMap = new HashMap();
        block0: for (int i = 0; i < fileDescArray.length; ++i) {
            List<LimeXMLDocument> list = fileDescArray[i].getLimeXMLDocuments();
            if (list.isEmpty()) {
                hashMap.clear();
                break;
            }
            for (LimeXMLDocument limeXMLDocument : list) {
                set = limeXMLDocument.getSchemaURI().toLowerCase(Locale.US);
                if (string != null && !string.equals(set)) continue;
                object = (Map)hashMap.get(set);
                if (object == null) {
                    object = new HashMap();
                    hashMap.put(set, object);
                }
                MetaEditorUtil.intersection(limeXMLDocument, (Map<String, String>)object);
                if (string == null) continue;
                continue block0;
            }
        }
        ArrayList<LimeXMLDocument> arrayList = new ArrayList<LimeXMLDocument>(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            set = MetaEditorUtil.clean((Map)entry.getValue()).entrySet();
            if (set.isEmpty()) continue;
            object = GuiCoreMediator.getLimeXMLSchemaRepository().getSchema(string2);
            if (object == null) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("LimeXMLSchema for " + string2 + " is null");
                continue;
            }
            boolean bl = false;
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(((LimeXMLSchema)object).getCanonicalizedFieldNames()));
            for (Map.Entry entry2 : set) {
                if (!hashSet.contains(entry2.getKey()) || entry2.getValue() == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                arrayList.add(GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument((Collection<? extends Map.Entry<String, String>>)set, string2));
                continue;
            }
            if (!LOG.isErrorEnabled()) continue;
            LOG.error("All fields of " + set + " are unknown for Schema " + object);
        }
        return arrayList.toArray(new LimeXMLDocument[0]);
    }

    private static Map intersection(LimeXMLDocument limeXMLDocument, Map<String, String> map) {
        String string;
        for (Map.Entry<String, String> object2 : limeXMLDocument.getNameValueSet()) {
            string = object2.getKey();
            String string2 = object2.getValue();
            String string3 = map.get(string);
            if (string3 == EMPTY_VALUE) continue;
            if (string3 == null || string3.equals(string2)) {
                map.put(string, string2);
                continue;
            }
            map.put(string, EMPTY_VALUE);
        }
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        hashSet.removeAll(limeXMLDocument.getNameSet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            map.put(string, EMPTY_VALUE);
        }
        return map;
    }

    private static Map<String, String> clean(Map<String, String> map) {
        Iterator<String> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != EMPTY_VALUE) continue;
            iterator.remove();
        }
        return map;
    }

    public static LimeXMLDocument merge(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        if (!limeXMLDocument.getSchemaURI().equalsIgnoreCase(limeXMLDocument2.getSchemaURI())) {
            throw new IllegalArgumentException("Current XML document and new XML document must be of the same type!");
        }
        HashMap<String, Map.Entry<String, String>> hashMap = new HashMap<String, Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
            hashMap.put(entry.getKey(), entry);
        }
        for (Map.Entry<String, String> entry : limeXMLDocument2.getNameValueSet()) {
            hashMap.put(entry.getKey(), entry);
        }
        return GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(hashMap.values(), limeXMLDocument.getSchemaURI());
    }

    static {
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio", I18nMarker.marktr("Audio"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__artist__", I18nMarker.marktr("Artist:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__album__", I18nMarker.marktr("Album:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__genre__", I18nMarker.marktr("Genre:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__year__", I18nMarker.marktr("Year:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__type__", I18nMarker.marktr("Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__track__", I18nMarker.marktr("Track:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__language__", I18nMarker.marktr("Language:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__seconds__", I18nMarker.marktr("Length:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__bitrate__", I18nMarker.marktr("Bitrate:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__comments__", I18nMarker.marktr("Comments:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__sha1__", I18nMarker.marktr("SHA1:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__price__", I18nMarker.marktr("Price:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__link__", I18nMarker.marktr("Link:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__action__", I18nMarker.marktr("Action:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video", I18nMarker.marktr("Video"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__type__", I18nMarker.marktr("Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__year__", I18nMarker.marktr("Year:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__rating__", I18nMarker.marktr("Rating:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__length__", I18nMarker.marktr("Length:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__comments__", I18nMarker.marktr("Comments:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__licensetype__", I18nMarker.marktr("License Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__action__", I18nMarker.marktr("Action:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__director__", I18nMarker.marktr("Director:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__studio__", I18nMarker.marktr("Studio:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__language__", I18nMarker.marktr("Language:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__stars__", I18nMarker.marktr("Stars: (Please separate with comma)"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__producer__", I18nMarker.marktr("Producer: (Please separate with comma)"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__subtitles__", I18nMarker.marktr("Subtitles: (Please separate with comma)"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document", I18nMarker.marktr("Document"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__topic__", I18nMarker.marktr("Topic:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__author__", I18nMarker.marktr("Author:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__licensetype__", I18nMarker.marktr("License Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application", I18nMarker.marktr("Application"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__name__", I18nMarker.marktr("Name:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__publisher__", I18nMarker.marktr("Publisher:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__platform__", I18nMarker.marktr("Platform:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__licensetype__", I18nMarker.marktr("License Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__license", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image", I18nMarker.marktr("Image"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__description__", I18nMarker.marktr("Description:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__artist__", I18nMarker.marktr("Artist:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__licensetype__", I18nMarker.marktr("License Type:"));
        EMPTY_VALUE = new String();
    }
}

