/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.limewire.io.ByteReader;

class BlockingHandshakeSupport
extends HandshakeSupport {
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    BlockingHandshakeSupport(Socket socket, InputStream inputStream, OutputStream outputStream) {
        super(socket.getInetAddress().getHostAddress());
        this.socket = socket;
        this.in = inputStream;
        this.out = outputStream;
    }

    String readLine() throws IOException {
        return this.readLine(8000);
    }

    String readLine(int n) throws IOException {
        int n2 = this.socket.getSoTimeout();
        try {
            this.socket.setSoTimeout(n);
            String string = new ByteReader(this.in).readLine();
            if (string == null) {
                throw new IOException("read null line");
            }
            String string2 = string;
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
        finally {
            this.socket.setSoTimeout(n2);
        }
    }

    void readHeaders() throws IOException {
        this.readHeaders(8000);
    }

    void readHeaders(int n) throws IOException {
        block2: {
            do {
                String string;
                if ((string = this.readLine(n)) == null) {
                    throw new IOException("unexpected end of file");
                }
                if (!this.processReadHeader(string)) break block2;
            } while (this.getHeadersReadSize() <= ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue());
            throw new IOException("too many headers");
        }
    }

    void writeConnectLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendConnectLine(stringBuilder);
        this.writeLine(stringBuilder.toString());
    }

    void writeResponse(HandshakeResponse handshakeResponse) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendResponse(handshakeResponse, stringBuilder);
        this.writeLine(stringBuilder.toString());
    }

    void writeLine(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new NullPointerException("null or empty string: " + string);
        }
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
        this.out.flush();
    }

    void sendHeaders(Properties properties) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHeaders(properties, stringBuilder);
        this.writeLine(stringBuilder.toString());
    }
}

