/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.util.Properties;

public final class LeafHandshakeResponder
extends DefaultHandshakeResponder {
    private final HeadersFactory headersFactory;
    private final HandshakeServices handshakeServices;

    LeafHandshakeResponder(String string, HeadersFactory headersFactory, HandshakeServices handshakeServices) {
        super(string);
        this.headersFactory = headersFactory;
        this.handshakeServices = handshakeServices;
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse handshakeResponse) {
        if (!handshakeResponse.isUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse(HandshakeStatus.WE_ARE_LEAVES);
        }
        if (this.getLocalePreferencing() && !ApplicationSettings.LANGUAGE.getValue().equals(handshakeResponse.getLocalePref())) {
            return HandshakeResponse.createLeafRejectLocaleOutgoingResponse();
        }
        HandshakeStatus handshakeStatus = this.handshakeServices.getHandshakeStatusForResponse(handshakeResponse);
        if (!handshakeStatus.isAcceptable()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse(handshakeStatus);
        }
        Properties properties = new Properties();
        if (handshakeResponse.isDeflateAccepted()) {
            properties.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(properties);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse(this.handshakeServices);
        }
        if (!handshakeResponse.isUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse(HandshakeStatus.WE_ARE_LEAVES);
        }
        Properties properties = this.headersFactory.createLeafHeaders(this.getRemoteIP());
        HandshakeStatus handshakeStatus = this.handshakeServices.getHandshakeStatusForResponse(handshakeResponse);
        if (!handshakeStatus.isAcceptable()) {
            return HandshakeResponse.createLeafRejectIncomingResponse(handshakeResponse, handshakeStatus, this.handshakeServices);
        }
        if (handshakeResponse.isDeflateAccepted()) {
            properties.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(handshakeResponse, properties, this.handshakeServices);
    }
}

