/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.HeaderInterceptor;

public class FWNodeInfoInterceptor
implements HeaderInterceptor {
    private final HTTPUploader uploader;
    private final PushEndpointFactory pushEndpointFactory;

    public FWNodeInfoInterceptor(HTTPUploader hTTPUploader, PushEndpointFactory pushEndpointFactory) {
        this.uploader = hTTPUploader;
        this.pushEndpointFactory = pushEndpointFactory;
    }

    public void process(Header header, HttpContext httpContext) throws HttpException, IOException {
        this.readPushEndPoint(header);
    }

    void readPushEndPoint(Header header) {
        if (HTTPHeaderName.FW_NODE_INFO.matches(header)) {
            try {
                PushEndpoint pushEndpoint = this.pushEndpointFactory.createPushEndpoint(header.getValue());
                this.uploader.setPushEndpoint(pushEndpoint);
                this.uploader.setBrowseHostEnabled(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

