/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.settings.ChatSettings;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FeaturesWriter {
    private final NetworkManager networkManager;

    @Inject
    public FeaturesWriter(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public Set<HTTPHeaderValue> getFeaturesValue() {
        HashSet<HTTPHeaderValue> hashSet = new HashSet<HTTPHeaderValue>(4);
        hashSet.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
        if (ChatSettings.CHAT_ENABLED.getValue()) {
            hashSet.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
        }
        hashSet.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
        if (!this.networkManager.acceptedIncomingConnection() && this.networkManager.canDoFWT()) {
            hashSet.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
        }
        return hashSet;
    }
}

