/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.licenses.CCLicense;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CCConstants {
    private static final Log LOG = LogFactory.getLog(CCLicense.class);
    public static final String CC_URI_PREFIX = "creativecommons.org/licenses/";
    public static final String URL_INDICATOR = "verify at";
    public static final String CC_RDF_HEADER = "<!-- <rdf:RDF xmlns=\"http://web.resource.org/cc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">";
    public static final String CC_RDF_FOOTER = "</rdf:RDF> -->";
    public static final int ATTRIBUTION = 0;
    public static final int ATTRIBUTION_NO_DERIVS = 1;
    public static final int ATTRIBUTION_NON_COMMERCIAL = 2;
    public static final int ATTRIBUTION_NON_COMMERCIAL_NO_DERIVS = 3;
    public static final int ATTRIBUTION_SHARE = 4;
    public static final int ATTRIBUTION_SHARE_NON_COMMERCIAL = 6;
    public static final String ATTRIBUTION_URI = "http://creativecommons.org/licenses/by/2.5/";
    public static final String ATTRIBUTION_NO_DERIVS_URI = "http://creativecommons.org/licenses/by-nd/2.5/";
    public static final String ATTRIBUTION_NON_COMMERCIAL_URI = "http://creativecommons.org/licenses/by-nc/2.5/";
    public static final String ATTRIBUTION_NON_COMMERCIAL_NO_DERIVS_URI = "http://creativecommons.org/licenses/by-nc-nd/2.5/";
    public static final String ATTRIBUTION_SHARE_URI = "http://creativecommons.org/licenses/by-sa/2.5/";
    public static final String ATTRIBUTION_SHARE_NON_COMMERCIAL_URI = "http://creativecommons.org/licenses/by-nc-sa/2.5/";
    private static final Map<Integer, String> LICENSE_URI_MAP = new HashMap<Integer, String>();

    public static String getLicenseURI(int n) {
        return LICENSE_URI_MAP.get(new Integer(n));
    }

    public static String getLicenseElement(int n) {
        Integer n2 = new Integer(n);
        assert (LICENSE_URI_MAP.containsKey(n2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<License rdf:about=\"").append(LICENSE_URI_MAP.get(n2)).append("\">");
        stringBuilder.append("<requires rdf:resource=\"http://web.resource.org/cc/Attribution\" />");
        stringBuilder.append("<permits rdf:resource=\"http://web.resource.org/cc/Reproduction\" />");
        stringBuilder.append("<permits rdf:resource=\"http://web.resource.org/cc/Distribution\" />");
        if ((n & 1) == 0) {
            stringBuilder.append("<permits rdf:resource=\"http://web.resource.org/cc/DerivativeWorks\" />");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("<prohibits rdf:resource=\"http://web.resource.org/cc/CommercialUse\" />");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("<requires rdf:resource=\"http://web.resource.org/cc/ShareAlike\" />");
        }
        stringBuilder.append("<requires rdf:resource=\"http://web.resource.org/cc/Notice\" />");
        stringBuilder.append("</License>");
        return stringBuilder.toString();
    }

    static URL guessLicenseDeed(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(CC_URI_PREFIX);
        if (n == -1) {
            return null;
        }
        int n2 = string.lastIndexOf("http://", n);
        if (n2 == -1) {
            return null;
        }
        if (n2 != 0 && string.charAt(n2 - 1) != ' ') {
            return null;
        }
        int n3 = string.indexOf(" ", n2);
        if (n3 == -1) {
            n3 = string.length();
        } else if (n3 < n) {
            return null;
        }
        try {
            return new URL(string.substring(n2, n3));
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warn("Unable to create URL from license: " + string, malformedURLException);
            return null;
        }
    }

    static {
        LICENSE_URI_MAP.put(new Integer(0), ATTRIBUTION_URI);
        LICENSE_URI_MAP.put(new Integer(1), ATTRIBUTION_NO_DERIVS_URI);
        LICENSE_URI_MAP.put(new Integer(2), ATTRIBUTION_NON_COMMERCIAL_URI);
        LICENSE_URI_MAP.put(new Integer(3), ATTRIBUTION_NON_COMMERCIAL_NO_DERIVS_URI);
        LICENSE_URI_MAP.put(new Integer(4), ATTRIBUTION_SHARE_URI);
        LICENSE_URI_MAP.put(new Integer(6), ATTRIBUTION_SHARE_NON_COMMERCIAL_URI);
    }
}

