/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.VerificationListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.http.LimeHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LicenseVerifier {
    private static final ExecutorService VQUEUE = ExecutorsHelper.newProcessingQueue("LicenseVerifier");
    private final Provider<LicenseCache> licenseCache;
    private final Provider<LimeHttpClient> httpClientProvider;

    @Inject
    public LicenseVerifier(Provider<LicenseCache> provider, Provider<LimeHttpClient> provider2) {
        this.licenseCache = provider;
        this.httpClientProvider = provider2;
    }

    public void verify(License license, VerificationListener verificationListener) {
        VQUEUE.execute(new Verifier(license, verificationListener));
    }

    public void verifyAndWait(License license, VerificationListener verificationListener) throws InterruptedException, ExecutionException {
        Future<?> future = VQUEUE.submit(new Verifier(license, verificationListener));
        future.get();
    }

    private class Verifier
    implements Runnable {
        private final License license;
        private final VerificationListener verificationListener;

        public Verifier(License license, VerificationListener verificationListener) {
            this.license = license;
            this.verificationListener = verificationListener;
        }

        public void run() {
            this.license.verify((LicenseCache)LicenseVerifier.this.licenseCache.get(), (LimeHttpClient)LicenseVerifier.this.httpClientProvider.get());
            if (this.verificationListener != null) {
                this.verificationListener.licenseVerified(this.license);
            }
        }
    }
}

