/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messagehandlers.OOBSecurityToken;
import com.limegroup.gnutella.messagehandlers.OOBSession;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

@Singleton
public class OOBHandler
implements MessageHandler,
Runnable {
    private static final Log LOG = LogFactory.getLog(OOBHandler.class);
    private final MessageRouter router;
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;
    private final ScheduledExecutorService executor;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Map<Integer, OOBSession> OOBSessions = Collections.synchronizedMap(new HashMap());

    @Inject
    public OOBHandler(MessageRouter messageRouter, MACCalculatorRepositoryManager mACCalculatorRepositoryManager, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.router = messageRouter;
        this.MACCalculatorRepositoryManager = mACCalculatorRepositoryManager;
        this.executor = scheduledExecutorService;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        if (message instanceof ReplyNumberVendorMessage) {
            this.handleRNVM((ReplyNumberVendorMessage)message, replyHandler);
        } else if (message instanceof QueryReply) {
            this.handleOOBReply((QueryReply)message, replyHandler);
        } else {
            throw new IllegalArgumentException("can't handle this type of message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRNVM(ReplyNumberVendorMessage replyNumberVendorMessage, final ReplyHandler replyHandler) {
        Object object;
        int n;
        GUID gUID = new GUID(replyNumberVendorMessage.getGUID());
        if (!this.router.isQueryAlive(gUID) || (n = this.router.getNumOOBToRequest(replyNumberVendorMessage)) <= 0) {
            this.router.addBypassedSource(replyNumberVendorMessage, replyHandler);
            this.outOfBandStatistics.addBypassedResponse(replyNumberVendorMessage.getNumResults());
            return;
        }
        LimeACKVendorMessage limeACKVendorMessage = null;
        if (replyNumberVendorMessage.isOOBv3()) {
            object = new OOBSecurityToken(new OOBSecurityToken.OOBTokenData(replyHandler, replyNumberVendorMessage.getGUID(), n), this.MACCalculatorRepositoryManager);
            int n2 = Arrays.hashCode(object.getBytes());
            Map<Integer, OOBSession> map = this.OOBSessions;
            synchronized (map) {
                if (!this.OOBSessions.containsKey(n2)) {
                    this.OOBSessions.put(n2, new OOBSession((SecurityToken)object, n, new GUID(replyNumberVendorMessage.getGUID()), true));
                    limeACKVendorMessage = new LimeACKVendorMessage(gUID, n, (SecurityToken)object);
                }
            }
        } else {
            limeACKVendorMessage = new LimeACKVendorMessage(gUID, n);
        }
        if (limeACKVendorMessage != null) {
            this.outOfBandStatistics.addRequestedResponse(n);
            replyHandler.reply(limeACKVendorMessage);
            if (MessageSettings.OOB_REDUNDANCY.getValue()) {
                object = limeACKVendorMessage;
                this.executor.schedule(new Runnable((LimeACKVendorMessage)object){
                    final /* synthetic */ LimeACKVendorMessage val$ackf;
                    {
                        this.val$ackf = limeACKVendorMessage;
                    }

                    public void run() {
                        replyHandler.reply(this.val$ackf);
                    }
                }, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOOBReply(QueryReply queryReply, ReplyHandler replyHandler) {
        SecurityToken securityToken;
        byte[] byArray;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Handling reply: " + queryReply + ", from: " + replyHandler);
        }
        if (!Arrays.equals(byArray = replyHandler.getInetAddress().getAddress(), queryReply.getIPBytes())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("IP addresses of sender and packet did not match, sender: " + replyHandler.getInetAddress() + ", packet: " + queryReply.getIP());
            }
            try {
                if (queryReply.getNeedsPush() || !this.networkInstanceUtils.isPrivateAddress(queryReply.getIPBytes())) {
                    queryReply.setOOBAddress(replyHandler.getInetAddress(), replyHandler.getPort());
                }
            }
            catch (BadPacketException badPacketException) {
                return;
            }
        }
        if ((securityToken = this.getVerifiedSecurityToken(queryReply, replyHandler)) == null) {
            if (!SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                this.router.handleQueryReply(queryReply, replyHandler);
            }
            return;
        }
        short s = queryReply.getResultCount();
        this.outOfBandStatistics.addReceivedResponse(s);
        int n = securityToken.getBytes()[0] & 0xFF;
        boolean bl = false;
        GUID gUID = new GUID(queryReply.getGUID());
        if (!this.router.isQueryAlive(gUID)) {
            bl = true;
        } else {
            Map<Integer, OOBSession> map = this.OOBSessions;
            synchronized (map) {
                int n2;
                int n3 = Arrays.hashCode(securityToken.getBytes());
                OOBSession oOBSession = this.OOBSessions.get(n3);
                if (oOBSession == null) {
                    oOBSession = new OOBSession(securityToken, n, gUID, false);
                    this.OOBSessions.put(n3, oOBSession);
                }
                if ((n2 = oOBSession.getRemainingResultsCount() - s) >= 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Requested >= than got (" + n2 + " left over)");
                    }
                    try {
                        int n4 = oOBSession.countAddedResponses(queryReply.getResultsArray());
                        if (n4 > 0) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Handling the reply.");
                            }
                            this.router.handleQueryReply(queryReply, replyHandler);
                        }
                    }
                    catch (BadPacketException badPacketException) {
                        // empty catch block
                    }
                }
            }
        }
        if (bl) {
            this.router.addBypassedSource(queryReply, replyHandler);
        }
    }

    private SecurityToken getVerifiedSecurityToken(QueryReply queryReply, ReplyHandler replyHandler) {
        byte[] byArray = queryReply.getSecurityToken();
        if (byArray == null) {
            return null;
        }
        try {
            OOBSecurityToken oOBSecurityToken = new OOBSecurityToken(byArray, this.MACCalculatorRepositoryManager);
            OOBSecurityToken.OOBTokenData oOBTokenData = new OOBSecurityToken.OOBTokenData(replyHandler, queryReply.getGUID(), byArray[0] & 0xFF);
            if (oOBSecurityToken.isFor(oOBTokenData)) {
                return oOBSecurityToken;
            }
        }
        catch (InvalidSecurityTokenException invalidSecurityTokenException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expire() {
        Map<Integer, OOBSession> map = this.OOBSessions;
        synchronized (map) {
            Iterator<Map.Entry<Integer, OOBSession>> iterator = this.OOBSessions.entrySet().iterator();
            while (iterator.hasNext()) {
                if (this.router.isQueryAlive(iterator.next().getValue().getGUID())) continue;
                iterator.remove();
            }
        }
    }

    public void run() {
        this.expire();
    }

    @InspectableContainer
    private class OOBInspectable {
        @InspectionPoint(value="oob sessions")
        public final Inspectable oobSessions = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                ArrayList<Object> arrayList;
                Map map = OOBHandler.this.OOBSessions;
                synchronized (map) {
                    arrayList = new ArrayList<Object>(OOBHandler.this.OOBSessions.size());
                    for (OOBSession oOBSession : OOBHandler.this.OOBSessions.values()) {
                        arrayList.add(oOBSession.inspect());
                    }
                }
                return arrayList;
            }
        };

        private OOBInspectable() {
        }
    }
}

