/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.limewire.collection.IntSet;
import org.limewire.inspection.Inspectable;
import org.limewire.security.SecurityToken;

class OOBSession
implements Inspectable {
    private final List<Long> responseTimestamps = new ArrayList<Long>(10);
    private final List<Integer> responseCounts = new ArrayList<Integer>(10);
    private final List<Integer> addedResponses = new ArrayList<Integer>(10);
    private final long start;
    private final boolean early;
    private final SecurityToken token;
    private final IntSet urnHashCodes;
    private IntSet responseHashCodes;
    private final int requestedResponseCount;
    private final GUID guid;

    OOBSession(SecurityToken securityToken, int n, GUID gUID, boolean bl) {
        this.token = securityToken;
        this.requestedResponseCount = n;
        this.urnHashCodes = new IntSet(n);
        this.guid = gUID;
        this.early = bl;
        this.start = System.currentTimeMillis();
    }

    GUID getGUID() {
        return this.guid;
    }

    int countAddedResponses(Response[] responseArray) {
        int n = 0;
        for (Response response : responseArray) {
            Set<URN> set = response.getUrns();
            if (!set.isEmpty()) {
                n += this.urnHashCodes.add(set.iterator().next().hashCode()) ? 1 : 0;
                continue;
            }
            if (this.responseHashCodes == null) {
                this.responseHashCodes = new IntSet();
            }
            n += this.responseHashCodes.add(response.hashCode()) ? 1 : 0;
        }
        this.responseTimestamps.add(System.currentTimeMillis());
        this.responseCounts.add(responseArray.length);
        this.addedResponses.add(n);
        return n;
    }

    final int getRemainingResultsCount() {
        return this.requestedResponseCount - this.urnHashCodes.size() - (this.responseHashCodes != null ? this.responseHashCodes.size() : 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OOBSession)) {
            return false;
        }
        OOBSession oOBSession = (OOBSession)object;
        return Arrays.equals(this.token.getBytes(), oOBSession.token.getBytes());
    }

    public Object inspect() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("start", this.start);
        hashMap.put("urnh", this.urnHashCodes.size());
        if (this.responseHashCodes != null) {
            hashMap.put("rhh", this.responseHashCodes.size());
        }
        hashMap.put("rrc", this.requestedResponseCount);
        hashMap.put("timestamps", this.responseTimestamps);
        hashMap.put("rcounts", this.responseCounts);
        hashMap.put("added", this.addedResponses);
        hashMap.put("early", this.early);
        return hashMap;
    }
}

