/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.setting.LongSetting;
import org.limewire.setting.StringArraySetting;

abstract class RestrictedResponder
implements SimppListener,
MessageHandler {
    private volatile IPList allowed;
    private final StringArraySetting setting;
    private final SecureMessageVerifier verifier;
    private final LongSetting lastRoutedVersion;
    private final NetworkManager networkManager;
    private final UDPReplyHandlerFactory udpReplyHandlerFactory;
    private final UDPReplyHandlerCache udpReplyHandlerCache;
    private final Executor messageExecutorService;
    private final NetworkInstanceUtils networkInstanceUtils;

    public RestrictedResponder(StringArraySetting stringArraySetting, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory uDPReplyHandlerFactory, UDPReplyHandlerCache uDPReplyHandlerCache, Executor executor, NetworkInstanceUtils networkInstanceUtils) {
        this(stringArraySetting, null, null, networkManager, simppManager, uDPReplyHandlerFactory, uDPReplyHandlerCache, executor, networkInstanceUtils);
    }

    public RestrictedResponder(StringArraySetting stringArraySetting, SecureMessageVerifier secureMessageVerifier, LongSetting longSetting, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory uDPReplyHandlerFactory, UDPReplyHandlerCache uDPReplyHandlerCache, Executor executor, NetworkInstanceUtils networkInstanceUtils) {
        this.setting = stringArraySetting;
        this.verifier = secureMessageVerifier;
        this.lastRoutedVersion = longSetting;
        this.networkManager = networkManager;
        this.udpReplyHandlerFactory = uDPReplyHandlerFactory;
        this.udpReplyHandlerCache = uDPReplyHandlerCache;
        this.messageExecutorService = executor;
        this.networkInstanceUtils = networkInstanceUtils;
        this.allowed = new IPList();
        this.allowed.add("*.*.*.*");
        simppManager.addListener(this);
        this.updateAllowed();
    }

    private void updateAllowed() {
        IPList iPList = new IPList();
        try {
            for (String string : this.setting.getValue()) {
                iPList.add(new IP(string));
            }
            if (iPList.isValidFilter(false, this.networkInstanceUtils)) {
                this.allowed = iPList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void simppUpdated(int n) {
        this.updateAllowed();
    }

    public final void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        System.out.print("Handling message: " + message);
        if (message instanceof RoutableGGEPMessage) {
            if (this.verifier != null && message instanceof SecureMessage) {
                this.verifier.verify((SecureMessage)((Object)message), new SecureCallback(inetSocketAddress, replyHandler));
            } else {
                this.processRoutableMessage((RoutableGGEPMessage)message, inetSocketAddress, replyHandler);
            }
        } else {
            if (!this.allowed.contains(new IP(replyHandler.getAddress()))) {
                return;
            }
            this.processAllowedMessage(message, inetSocketAddress, replyHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRoutableMessage(RoutableGGEPMessage routableGGEPMessage, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        if (routableGGEPMessage.getReturnAddress() != null) {
            if (routableGGEPMessage.getRoutableVersion() < 0L) {
                return;
            }
            replyHandler = this.udpReplyHandlerFactory.createUDPReplyHandler(routableGGEPMessage.getReturnAddress().getInetAddress(), routableGGEPMessage.getReturnAddress().getPort(), this.udpReplyHandlerCache.getPersonalFilter());
        } else if (routableGGEPMessage.getDestinationAddress() != null ? !Arrays.equals(this.networkManager.getExternalAddress(), routableGGEPMessage.getDestinationAddress().getInetAddress().getAddress()) : routableGGEPMessage.getRoutableVersion() < 0L) {
            return;
        }
        if (!this.allowed.contains(new IP(replyHandler.getAddress()))) {
            return;
        }
        long l = routableGGEPMessage.getRoutableVersion();
        if (this.lastRoutedVersion != null && l > 0L) {
            LongSetting longSetting = this.lastRoutedVersion;
            synchronized (longSetting) {
                if (l <= this.lastRoutedVersion.getValue()) {
                    return;
                }
                this.lastRoutedVersion.setValue(l);
            }
        }
        this.processAllowedMessage(routableGGEPMessage, inetSocketAddress, replyHandler);
    }

    protected abstract void processAllowedMessage(Message var1, InetSocketAddress var2, ReplyHandler var3);

    private class SecureCallback
    implements SecureMessageCallback {
        private final InetSocketAddress addr;
        private final ReplyHandler handler;

        SecureCallback(InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            this.addr = inetSocketAddress;
            this.handler = replyHandler;
        }

        public void handleSecureMessage(final SecureMessage secureMessage, boolean bl) {
            if (!bl) {
                return;
            }
            RestrictedResponder.this.messageExecutorService.execute(new Runnable(){

                public void run() {
                    RestrictedResponder.this.processRoutableMessage((RoutableGGEPMessage)secureMessage, SecureCallback.this.addr, SecureCallback.this.handler);
                }
            });
        }
    }
}

