/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.util.COBSUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.limewire.collection.NameValue;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGEP {
    public static final String GGEP_HEADER_BROWSE_HOST = "BH";
    public static final String GGEP_HEADER_DAILY_AVERAGE_UPTIME = "DU";
    public static final String GGEP_HEADER_UNICAST_SUPPORT = "GUE";
    public static final String GGEP_HEADER_UP_SUPPORT = "UP";
    public static final String GGEP_HEADER_QUERY_KEY_SUPPORT = "QK";
    public static final String GGEP_HEADER_SECURE_OOB = "SO";
    public static final String GGEP_HEADER_MULTICAST_RESPONSE = "MCAST";
    public static final String GGEP_HEADER_PUSH_PROXY = "PUSH";
    public static final String GGEP_HEADER_PUSH_PROXY_TLS = "PUSH_TLS";
    public static final String GGEP_HEADER_ALTS = "ALT";
    public static final String GGEP_HEADER_ALTS_TLS = "ALT_TLS";
    public static final String GGEP_HEADER_IPPORT = "IP";
    public static final String GGEP_HEADER_UDP_HOST_CACHE = "UDPHC";
    public static final String GGEP_HEADER_SUPPORT_CACHE_PONGS = "SCP";
    public static final String GGEP_HEADER_PACKED_IPPORTS = "IPP";
    public static final String GGEP_HEADER_PACKED_IPPORTS_TLS = "IPP_TLS";
    public static final String GGEP_HEADER_TLS_CAPABLE = "TLS";
    public static final String GGEP_HEADER_PACKED_HOSTCACHES = "PHC";
    public static final String GGEP_HEADER_SHA1 = "S1";
    public static final String GGEP_HEADER_TTROOT = "TT";
    public static final String GGEP_HEADER_SHA1_VALID = "SV";
    public static final String GGEP_HEADER_DHT_SUPPORT = "DHT";
    public static final String GGEP_HEADER_DHT_IPPORTS = "DHTIPP";
    public static final String GGEP_HEADER_FEATURE_QUERY = "WH";
    public static final String GGEP_HEADER_NO_PROXY = "NP";
    public static final String GGEP_HEADER_META = "M";
    public static final String GGEP_HEADER_CLIENT_LOCALE = "LOC";
    public static final String GGEP_HEADER_CREATE_TIME = "CT";
    public static final String GGEP_HEADER_FW_TRANS = "FW";
    public static final String GGEP_HEADER_SECURE_BLOCK = "SB";
    public static final String GGEP_HEADER_SIGNATURE = "SIG";
    public static final String GGEP_HEADER_LARGE_FILE = "LF";
    public static final String GGEP_HEADER_PARTIAL_RESULT_PREFIX = "PR";
    public static final String GGEP_HEADER_PARTIAL_RESULT_UNVERIFIED = "PRU";
    public static final String GGEP_HEADER_RETURN_PATH_SOURCE = "RPS";
    public static final String GGEP_HEADER_RETURN_PATH_HOPS = "RPH";
    public static final String GGEP_HEADER_RETURN_PATH_ME = "RPI";
    public static final String GGEP_HEADER_RETURN_PATH_TTL = "RPT";
    public static final int MAX_KEY_SIZE_IN_BYTES = 15;
    public static final int MAX_VALUE_SIZE_IN_BYTES = 262143;
    public static final byte GGEP_PREFIX_MAGIC_NUMBER = -61;
    private final Map<String, Object> _props = new TreeMap<String, Object>();
    public final boolean useCOBS;
    private volatile int hashCode = 0;

    public GGEP(boolean bl) {
        this.useCOBS = bl;
    }

    public GGEP() {
        this(false);
    }

    public GGEP(byte[] byArray, int n) throws BadGGEPBlockException {
        this(byArray, n, null);
    }

    public GGEP(byte[] byArray, int n, int[] nArray) throws BadGGEPBlockException {
        if (byArray.length - n < 4) {
            throw new BadGGEPBlockException();
        }
        if (byArray[n] != -61) {
            throw new BadGGEPBlockException();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = n + 1;
        while (!bl2) {
            try {
                this.sanityCheck(byArray[n2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new BadGGEPBlockException();
            }
            bl2 = this.isLastExtension(byArray[n2]);
            boolean bl3 = this.isEncoded(byArray[n2]);
            boolean bl4 = this.isCompressed(byArray[n2]);
            int n3 = this.deriveHeaderLength(byArray[n2]);
            ++n2;
            String string = null;
            try {
                string = new String(byArray, n2, n3);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new BadGGEPBlockException();
            }
            int[] nArray2 = new int[1];
            int n4 = this.deriveDataLength(byArray, n2 += n3, nArray2);
            byte[] byArray2 = null;
            n2 += nArray2[0];
            if (n4 > 0) {
                byte[] byArray3 = new byte[n4];
                try {
                    System.arraycopy(byArray, n2, byArray3, 0, n4);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new BadGGEPBlockException();
                }
                if (bl3) {
                    bl = true;
                    try {
                        byArray3 = COBSUtil.cobsDecode(byArray3);
                    }
                    catch (IOException iOException) {
                        throw new BadGGEPBlockException("Bad COBS Encoding");
                    }
                }
                if (bl4) {
                    try {
                        byArray3 = IOUtils.inflate(byArray3);
                    }
                    catch (IOException iOException) {
                        throw new BadGGEPBlockException("Bad compressed data");
                    }
                }
                byArray2 = byArray3;
                n2 += n4;
            }
            if (bl4) {
                this._props.put(string, new NeedsCompression(byArray2));
                continue;
            }
            this._props.put(string, byArray2);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n2;
        }
        this.useCOBS = bl;
    }

    public void merge(GGEP gGEP) {
        this._props.putAll(gGEP._props);
    }

    private void sanityCheck(byte by) throws BadGGEPBlockException {
        if ((by & 0x10) != 0) {
            throw new BadGGEPBlockException();
        }
    }

    private boolean isLastExtension(byte by) {
        boolean bl = false;
        if ((by & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isEncoded(byte by) {
        boolean bl = false;
        if ((by & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isCompressed(byte by) {
        boolean bl = false;
        if ((by & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    private int deriveHeaderLength(byte by) throws BadGGEPBlockException {
        int n = 0;
        n = by & 0xF;
        if (n == 0) {
            throw new BadGGEPBlockException();
        }
        return n;
    }

    private int deriveDataLength(byte[] byArray, int n, int[] nArray) throws BadGGEPBlockException {
        byte by;
        int n2 = 0;
        int n3 = 0;
        do {
            try {
                by = byArray[n++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new BadGGEPBlockException();
            }
            n2 = n2 << 6 | by & 0x3F;
            if (++n3 <= 3) continue;
            throw new BadGGEPBlockException();
        } while (64 != (by & 0x40));
        nArray[0] = n3;
        return n2;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.getHeaders().size() > 0) {
            outputStream.write(-61);
            Iterator<String> iterator = this.getHeaders().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                byte[] byArray = this.get(string);
                int n = 0;
                boolean bl = this.shouldCOBSEncode(byArray);
                boolean bl2 = this.shouldCompress(string);
                if (byArray != null) {
                    if (bl2 && (byArray = IOUtils.deflate(byArray)).length > 262143) {
                        throw new IllegalArgumentException("value for [" + string + "] too large after compression");
                    }
                    if (bl) {
                        byArray = COBSUtil.cobsEncode(byArray);
                    }
                    n = byArray.length;
                }
                this.writeHeader(string, n, !iterator.hasNext(), outputStream, bl, bl2);
                if (n <= 0) continue;
                outputStream.write(byArray);
            }
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private final boolean shouldCOBSEncode(byte[] byArray) {
        return this.useCOBS && this.containsNull(byArray);
    }

    private final boolean shouldCompress(String string) {
        return this._props.get(string) instanceof NeedsCompression;
    }

    private void writeHeader(String string, int n, boolean bl, OutputStream outputStream, boolean bl2, boolean bl3) throws IOException {
        int n2;
        int n3 = 0;
        if (bl) {
            n3 |= 0x80;
        }
        if (bl2) {
            n3 |= 0x40;
        }
        if (bl3) {
            n3 |= 0x20;
        }
        outputStream.write(n3 |= string.getBytes().length);
        outputStream.write(string.getBytes());
        int n4 = n & 0x3F000;
        if (n > 4095) {
            n2 = 0x80 | (n4 >>= 12);
            outputStream.write(n2);
        }
        int n5 = n & 0xFC0;
        if (n > 63) {
            n2 = 0x80 | (n5 >>= 6);
            outputStream.write(n2);
        }
        int n6 = n & 0x3F;
        n2 = 0x40 | n6;
        outputStream.write(n2);
    }

    public int getHeaderOverhead(String string) {
        byte[] byArray = this.get(string);
        if (byArray == null) {
            throw new IllegalArgumentException("no data for key: " + string);
        }
        return 1 + string.length() + byArray.length + 1 + (byArray.length > 63 ? 1 : 0) + (byArray.length > 4095 ? 1 : 0);
    }

    public void putAll(List<? extends NameValue<?>> list) throws IllegalArgumentException {
        for (NameValue<?> nameValue : list) {
            String string = nameValue.getName();
            Object obj = nameValue.getValue();
            if (obj == null) {
                this.put(string);
                continue;
            }
            if (obj instanceof byte[]) {
                this.put(string, (byte[])obj);
                continue;
            }
            if (obj instanceof String) {
                this.put(string, (String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                this.put(string, (Integer)obj);
                continue;
            }
            if (obj instanceof Long) {
                this.put(string, (Long)obj);
                continue;
            }
            if (obj instanceof Byte) {
                this.put(string, (Byte)obj);
                continue;
            }
            throw new IllegalArgumentException("Unknown value: " + obj);
        }
    }

    public void putCompressed(String string, byte[] byArray) throws IllegalArgumentException {
        this.validateKey(string);
        this._props.put(string, new NeedsCompression(byArray));
    }

    public void put(String string, byte by) throws IllegalArgumentException {
        this.put(string, new byte[]{by});
    }

    public void put(String string, byte[] byArray) throws IllegalArgumentException {
        this.validateKey(string);
        this.validateValue(byArray);
        this._props.put(string, byArray);
    }

    public void put(String string, String string2) throws IllegalArgumentException {
        this.put(string, string2 == null ? null : string2.getBytes());
    }

    public void put(String string, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(string, ByteOrder.int2minLeb(n));
    }

    public void put(String string, long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(string, ByteOrder.long2minLeb(l));
    }

    public void put(String string) throws IllegalArgumentException {
        this.put(string, (byte[])null);
    }

    public byte[] getBytes(String string) throws BadGGEPPropertyException {
        byte[] byArray = this.get(string);
        if (byArray == null) {
            throw new BadGGEPPropertyException();
        }
        return byArray;
    }

    public String getString(String string) throws BadGGEPPropertyException {
        return new String(this.getBytes(string));
    }

    public int getInt(String string) throws BadGGEPPropertyException {
        byte[] byArray = this.getBytes(string);
        if (byArray.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (byArray.length > 4) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2int(byArray, 0, byArray.length);
    }

    public long getLong(String string) throws BadGGEPPropertyException {
        byte[] byArray = this.getBytes(string);
        if (byArray.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (byArray.length > 8) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2long(byArray, 0, byArray.length);
    }

    public boolean hasKey(String string) {
        return this._props.containsKey(string);
    }

    public Set<String> getHeaders() {
        return this._props.keySet();
    }

    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    public byte[] get(String string) {
        Object object = this._props.get(string);
        if (object instanceof NeedsCompression) {
            return ((NeedsCompression)object).data;
        }
        return (byte[])object;
    }

    private void validateKey(String string) throws IllegalArgumentException {
        byte[] byArray = string.getBytes();
        if (string.equals("") || byArray.length > 15 || this.containsNull(byArray)) {
            throw new IllegalArgumentException();
        }
    }

    private void validateValue(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null) {
            return;
        }
        if (byArray.length > 262143) {
            throw new IllegalArgumentException();
        }
    }

    private boolean containsNull(byte[] byArray) {
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GGEP)) {
            return false;
        }
        return this.subset((GGEP)object) && ((GGEP)object).subset(this);
    }

    private boolean subset(GGEP gGEP) {
        for (String string : this._props.keySet()) {
            byte[] byArray;
            byte[] byArray2 = this.get(string);
            if (byArray2 == null != ((byArray = gGEP.get(string)) == null)) {
                return false;
            }
            if (byArray2 == null || Arrays.equals(byArray2, byArray)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * ((Object)this._props).hashCode();
        }
        return this.hashCode;
    }

    private static class NeedsCompression {
        final byte[] data;

        NeedsCompression(byte[] byArray) {
            this.data = byArray;
        }
    }
}

