/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;

public class AdvancedStatsToggle
extends RoutableGGEPMessage {
    private static final int VERSION = 1;
    static final String TIME_KEY = "T";
    static final String OFF_KEY = "OFF";
    private final int time;

    public AdvancedStatsToggle(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 32, n, byArray2, network);
        try {
            this.time = this.ggep.hasKey(OFF_KEY) ? -1 : this.ggep.getInt(TIME_KEY);
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException();
        }
    }

    public AdvancedStatsToggle(RoutableGGEPMessage.GGEPSigner gGEPSigner, long l, int n) {
        super(F_LIME_VENDOR_ID, 32, 1, gGEPSigner, AdvancedStatsToggle.deriveGGEP(l, n));
        this.time = n;
    }

    private static GGEP deriveGGEP(long l, int n) {
        GGEP gGEP = new GGEP();
        if (n >= 0) {
            gGEP.put(TIME_KEY, n);
        } else {
            gGEP.put(OFF_KEY);
        }
        if (l >= 0L) {
            gGEP.put("V", l);
        }
        return gGEP;
    }

    public boolean shutOffNow() {
        return this.time < 0;
    }

    public int getTime() {
        return this.time;
    }
}

