/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.version.UpdateHandler;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CapabilitiesVMFactoryImpl
implements CapabilitiesVMFactory {
    private final Provider<DHTManager> dhtManager;
    private final Provider<SimppManager> simppManager;
    private final Provider<UpdateHandler> updateHandler;
    private volatile CapabilitiesVM currentCapabilities;

    @Inject
    public CapabilitiesVMFactoryImpl(Provider<DHTManager> provider, Provider<SimppManager> provider2, Provider<UpdateHandler> provider3) {
        this.dhtManager = provider;
        this.simppManager = provider2;
        this.updateHandler = provider3;
    }

    @Override
    public CapabilitiesVM getCapabilitiesVM() {
        if (this.currentCapabilities == null) {
            this.currentCapabilities = new CapabilitiesVM(this.getSupportedMessages());
        }
        return this.currentCapabilities;
    }

    @Override
    public void updateCapabilities() {
        this.currentCapabilities = new CapabilitiesVM(this.getSupportedMessages());
    }

    protected Set<CapabilitiesVM.SupportedMessageBlock> getSupportedMessages() {
        HashSet<CapabilitiesVM.SupportedMessageBlock> hashSet = new HashSet<CapabilitiesVM.SupportedMessageBlock>();
        CapabilitiesVM.SupportedMessageBlock supportedMessageBlock = null;
        supportedMessageBlock = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.FEATURE_SEARCH_BYTES, 1);
        hashSet.add(supportedMessageBlock);
        supportedMessageBlock = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.SIMPP_CAPABILITY_BYTES, this.simppManager.get().getVersion());
        hashSet.add(supportedMessageBlock);
        supportedMessageBlock = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.LIME_UPDATE_BYTES, this.updateHandler.get().getLatestId());
        hashSet.add(supportedMessageBlock);
        if (this.dhtManager.get().isMemberOfDHT()) {
            DHTManager.DHTMode dHTMode = this.dhtManager.get().getDHTMode();
            assert (dHTMode != null);
            supportedMessageBlock = new CapabilitiesVM.SupportedMessageBlock(dHTMode.getCapabilityName(), this.dhtManager.get().getVersion().shortValue());
            hashSet.add(supportedMessageBlock);
        }
        if (SSLSettings.isIncomingTLSEnabled()) {
            supportedMessageBlock = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.TLS_SUPPORT_BYTES, 1);
            hashSet.add(supportedMessageBlock);
        }
        return hashSet;
    }
}

