/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.IntervalSet;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Decorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadPongImpl
extends AbstractVendorMessage
implements HeadPong {
    private IntervalSet _ranges;
    private Set<IpPort> _altLocs;
    private Set<PushEndpoint> _pushLocs;
    private int _queueStatus;
    private boolean _fileFound;
    private boolean _completeFile;
    private byte[] _vendorId;
    private boolean _isFirewalled;
    private boolean _isDownloading;
    private boolean _tlsCapable;
    private boolean _routingBroken;
    private final PushEndpointFactory pushEndpointFactory;

    HeadPongImpl(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network, PushEndpointFactory pushEndpointFactory) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 24, n, byArray2, network);
        this.pushEndpointFactory = pushEndpointFactory;
        if (byArray2 == null || byArray2.length < 2) {
            throw new BadPacketException("bad payload");
        }
        if (n == 1) {
            this.setFieldsFromBinary(byArray2);
        } else if (n >= 2) {
            this.setFieldsFromGGEP(byArray2);
        } else {
            throw new BadPacketException("invalid version!");
        }
    }

    protected HeadPongImpl(GUID gUID, int n, byte[] byArray) {
        super(F_LIME_VENDOR_ID, 24, n, byArray);
        this.setGUID(gUID);
        this.pushEndpointFactory = null;
    }

    public Class<HeadPong> getHandlerClass() {
        return HeadPong.class;
    }

    private void setFieldsFromBinary(byte[] byArray) throws BadPacketException {
        if (byArray[1] > 15) {
            throw new BadPacketException("invalid payload!");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            byte by = (byte)(dataInputStream.readByte() & 0x1F);
            this._routingBroken = (by & 0x10) == 16;
            byte by2 = dataInputStream.readByte();
            if (!this.setFieldsFromCode(by2)) {
                return;
            }
            this._vendorId = new byte[4];
            dataInputStream.readFully(this._vendorId);
            this._queueStatus = dataInputStream.readByte();
            if (!this._completeFile && (by & 1) == 1) {
                this._ranges = this.readRanges(dataInputStream);
            }
            if ((by & 4) == 4) {
                this._pushLocs = this.readPushLocs(dataInputStream);
            }
            if ((by & 2) == 2) {
                this._altLocs = this.readLocs(dataInputStream);
            }
        }
        catch (IOException iOException) {
            throw new BadPacketException(iOException);
        }
    }

    private void setFieldsFromGGEP(byte[] byArray) throws BadPacketException {
        GGEP gGEP;
        try {
            gGEP = new GGEP(byArray, 0);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            throw new BadPacketException(badGGEPBlockException);
        }
        byte[] byArray2 = this.getRequiredGGEPField(gGEP, "C");
        if (!this.setFieldsFromCode(byArray2[0])) {
            return;
        }
        this._routingBroken = false;
        this._vendorId = this.getRequiredGGEPField(gGEP, "V");
        this._queueStatus = this.getRequiredGGEPField(gGEP, "Q")[0];
        byte[] byArray3 = this.getOptionalGGEPField(gGEP, "F");
        if (byArray3.length > 0) {
            this._tlsCapable = (byArray3[0] & 1) == 1;
        }
        try {
            byte[] byArray4;
            byte[] byArray5;
            byte[] byArray6 = this.getOptionalGGEPField(gGEP, "R");
            byte[] byArray7 = this.getOptionalGGEPField(gGEP, "R5");
            if (byArray6.length > 0 || byArray7.length > 0) {
                this._ranges = this.parseRanges(byArray6, byArray7);
            }
            if ((byArray5 = this.getOptionalGGEPField(gGEP, "P")).length > 0) {
                this._pushLocs = this.parsePushLocs(byArray5);
            }
            byte[] byArray8 = this.getOptionalGGEPField(gGEP, "T");
            BitNumbers bitNumbers = null;
            if (byArray8.length > 0) {
                bitNumbers = new BitNumbers(byArray8);
            }
            if ((byArray4 = this.getOptionalGGEPField(gGEP, "A")).length > 0) {
                this._altLocs = this.parseAltLocs(byArray4, bitNumbers);
            }
        }
        catch (IOException iOException) {
            throw new BadPacketException(iOException);
        }
    }

    private boolean setFieldsFromCode(byte by) {
        if (by == 0) {
            return false;
        }
        this._fileFound = true;
        if ((by & 4) == 4) {
            this._isFirewalled = true;
        }
        if ((by & 1) == 1) {
            this._completeFile = true;
        } else if ((by & 8) == 8) {
            this._isDownloading = true;
        }
        return true;
    }

    private byte[] getRequiredGGEPField(GGEP gGEP, String string) throws BadPacketException {
        try {
            byte[] byArray = gGEP.getBytes(string);
            if (byArray.length == 0) {
                throw new BadPacketException("no data for header: " + string + "!");
            }
            return byArray;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException(badGGEPPropertyException);
        }
    }

    private byte[] getOptionalGGEPField(GGEP gGEP, String string) {
        if (gGEP.hasKey(string)) {
            try {
                return gGEP.getBytes(string);
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return DataUtils.EMPTY_BYTE_ARRAY;
    }

    @Override
    public boolean hasFile() {
        return this._fileFound;
    }

    @Override
    public boolean hasCompleteFile() {
        return this.hasFile() && this._completeFile;
    }

    @Override
    public IntervalSet getRanges() {
        return this._ranges;
    }

    @Override
    public Set<IpPort> getAltLocs() {
        return this._altLocs;
    }

    @Override
    public Set<PushEndpoint> getPushLocs() {
        return this._pushLocs;
    }

    @Override
    public boolean isTLSCapable() {
        return this._tlsCapable;
    }

    @Override
    public Set<RemoteFileDesc> getAllLocsRFD(RemoteFileDesc remoteFileDesc, RemoteFileDescFactory remoteFileDescFactory) {
        HashSet<RemoteFileDesc> hashSet = new HashSet<RemoteFileDesc>();
        if (this._altLocs != null) {
            for (IpPort ipPort : this._altLocs) {
                hashSet.add(remoteFileDescFactory.createRemoteFileDesc(remoteFileDesc, ipPort));
            }
        }
        if (this._pushLocs != null) {
            for (PushEndpoint pushEndpoint : this._pushLocs) {
                hashSet.add(remoteFileDescFactory.createRemoteFileDesc(remoteFileDesc, pushEndpoint));
            }
        }
        return hashSet;
    }

    @Override
    public void updateRFD(RemoteFileDesc remoteFileDesc) {
        if (this.isBusy()) {
            remoteFileDesc.setRetryAfter(60);
        }
        remoteFileDesc.setQueueStatus(this.getQueueStatus());
        remoteFileDesc.setAvailableRanges(this.getRanges());
        remoteFileDesc.setSerializeProxies();
        remoteFileDesc.setTLSCapable(this.isTLSCapable());
    }

    @Override
    public String getVendor() {
        if (this._vendorId != null) {
            return new String(this._vendorId);
        }
        return null;
    }

    @Override
    public boolean isFirewalled() {
        return this._isFirewalled;
    }

    @Override
    public int getQueueStatus() {
        return this._queueStatus;
    }

    @Override
    public boolean isBusy() {
        return this._queueStatus >= 127;
    }

    @Override
    public boolean isDownloading() {
        return this._isDownloading;
    }

    @Override
    public boolean isRoutingBroken() {
        return this._routingBroken;
    }

    @Override
    public String toString() {
        return "HeadPong:  isRoutingBroken: " + this.isRoutingBroken() + ", hasFile: " + this.hasFile() + ", hasCompleteFile: " + this.hasCompleteFile() + ", isDownloading: " + this.isDownloading() + ", isFirewalled: " + this.isFirewalled() + ", queue rank: " + this.getQueueStatus() + ", \nranges: " + this.getRanges() + ", \nalts: " + this.getAltLocs() + ", \npushalts: " + this.getPushLocs();
    }

    private final IntervalSet readRanges(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return this.parseRanges(byArray, DataUtils.EMPTY_BYTE_ARRAY);
    }

    private IntervalSet parseRanges(byte[] byArray, byte[] byArray2) throws IOException {
        return IntervalSet.parseBytes(byArray, byArray2);
    }

    private final Set<PushEndpoint> readPushLocs(DataInputStream dataInputStream) throws IOException, BadPacketException {
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return this.parsePushLocs(byArray);
    }

    private Set<PushEndpoint> parsePushLocs(byte[] byArray) throws IOException, BadPacketException {
        HashSet<PushEndpoint> hashSet = new HashSet<PushEndpoint>();
        hashSet.addAll(this.unpackPushEPs(new ByteArrayInputStream(byArray)));
        return hashSet;
    }

    private List<PushEndpoint> unpackPushEPs(InputStream inputStream) throws BadPacketException, IOException {
        LinkedList<PushEndpoint> linkedList = new LinkedList<PushEndpoint>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (dataInputStream.available() > 0) {
            linkedList.add(this.pushEndpointFactory.createFromBytes(dataInputStream));
        }
        return Collections.unmodifiableList(linkedList);
    }

    private final Set<IpPort> readLocs(DataInputStream dataInputStream) throws IOException, BadPacketException {
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return this.parseAltLocs(byArray, null);
    }

    private Set<IpPort> parseAltLocs(byte[] byArray, final BitNumbers bitNumbers) throws IOException, BadPacketException {
        HashSet<IpPort> hashSet = new HashSet<IpPort>();
        try {
            if (bitNumbers == null) {
                hashSet.addAll(NetworkUtils.unpackIps(byArray));
            } else {
                hashSet.addAll(NetworkUtils.unpackIps(byArray, (Decorator<IpPort, ? extends IpPort>)new Decorator<IpPort, IpPort>(){
                    int i = 0;

                    @Override
                    public IpPort decorate(IpPort ipPort) {
                        if (bitNumbers.isSet(this.i)) {
                            ipPort = new ConnectableImpl(ipPort, true);
                        }
                        ++this.i;
                        return ipPort;
                    }
                }));
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw new BadPacketException(invalidDataException);
        }
        return hashSet;
    }

    @Override
    public byte[] getPayload() {
        return super.getPayload();
    }
}

