/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.InspectionResponse;
import com.limegroup.gnutella.messages.vendor.InspectionResponseFactory;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FECUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import org.limewire.inspection.InspectionException;
import org.limewire.inspection.Inspector;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.BEncoder;
import org.limewire.util.CommonUtils;

@Singleton
public class InspectionResponseFactoryImpl
implements InspectionResponseFactory {
    private static final String INSPECTION_FILE = "inspection.props";
    private static final int OLD_VERSION = 1;
    private static final int GGEP_VERSION = 2;
    private static final String DATA_KEY = "D";
    private static final String CHUNK_ID_KEY = "I";
    private static final String TOTAL_CHUNKS_KEY = "T";
    private static final String LENGTH_KEY = "L";
    private static final int PACKET_SIZE = 1300;
    private static final float REDUNDANCY = 1.2f;
    private final Inspector inspector;
    private final FECUtils fecUtils;

    @Inject
    public InspectionResponseFactoryImpl(Inspector inspector, FECUtils fECUtils) {
        this.inspector = inspector;
        this.inspector.load(new File(CommonUtils.getCurrentDirectory(), INSPECTION_FILE));
        this.fecUtils = fECUtils;
    }

    public InspectionResponse[] createResponses(InspectionRequest inspectionRequest) {
        byte[] byArray = this.derivePayload(inspectionRequest);
        if (byArray.length < 1300 || !inspectionRequest.supportsEncoding()) {
            return new InspectionResponse[]{new InspectionResponse(1, inspectionRequest.getGUID(), byArray)};
        }
        List<byte[]> list = this.fecUtils.encode(byArray, 1300, 1.2f);
        ArrayList<InspectionResponse> arrayList = new ArrayList<InspectionResponse>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            GGEP gGEP = new GGEP();
            gGEP.put(DATA_KEY, list.get(i));
            gGEP.put(CHUNK_ID_KEY, i);
            gGEP.put(TOTAL_CHUNKS_KEY, list.size());
            gGEP.put(LENGTH_KEY, byArray.length);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                continue;
            }
            arrayList.add(new InspectionResponse(2, inspectionRequest.getGUID(), byteArrayOutputStream.toByteArray()));
        }
        InspectionResponse[] inspectionResponseArray = new InspectionResponse[arrayList.size()];
        return arrayList.toArray(inspectionResponseArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] derivePayload(InspectionRequest inspectionRequest) {
        String[] stringArray = inspectionRequest.getRequestedFields();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>(stringArray.length);
        if (inspectionRequest.requestsTimeStamp()) {
            hashMap.put(-1, System.currentTimeMillis());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                hashMap.put(i, this.inspector.inspect(stringArray[i]));
                continue;
            }
            catch (InspectionException inspectionException) {
                // empty catch block
            }
        }
        if (hashMap.isEmpty()) {
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        try {
            try {
                BEncoder.getEncoder(deflaterOutputStream, false, true, "UTF-8").encodeDict(hashMap);
            }
            catch (Throwable throwable) {
                String string = throwable.toString();
                String string2 = "d5:error" + string.length() + ":" + string + "e";
                deflaterOutputStream.write(string2.getBytes());
            }
            deflaterOutputStream.flush();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            IOUtils.close(deflaterOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

