/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class MessagesSupportedVendorMessage
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    public static final int VERSION = 0;
    private final Set<SupportedMessageBlock> _messagesSupported = new HashSet<SupportedMessageBlock>();

    MessagesSupportedVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_NULL_VENDOR_ID, 0, n, byArray2, network);
        if (this.getVersion() > 0) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPayload());
            int n2 = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
            for (int i = 0; i < n2; ++i) {
                this._messagesSupported.add(new SupportedMessageBlock(byteArrayInputStream));
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
    }

    public MessagesSupportedVendorMessage() {
        super(F_NULL_VENDOR_ID, 0, 0, MessagesSupportedVendorMessage.derivePayload(MessagesSupportedVendorMessage.addSupportedMessages(new HashSet<SupportedMessageBlock>())));
        MessagesSupportedVendorMessage.addSupportedMessages(this._messagesSupported);
    }

    MessagesSupportedVendorMessage(Set<SupportedMessageBlock> set) {
        super(F_NULL_VENDOR_ID, 0, 0, MessagesSupportedVendorMessage.derivePayload(set));
    }

    private static byte[] derivePayload(Set<SupportedMessageBlock> set) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)set.size(), byteArrayOutputStream);
            for (SupportedMessageBlock supportedMessageBlock : set) {
                supportedMessageBlock.encode(byteArrayOutputStream);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    static Set<SupportedMessageBlock> addSupportedMessages(Set<SupportedMessageBlock> set) {
        SupportedMessageBlock supportedMessageBlock = null;
        supportedMessageBlock = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 7, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_GTKG_VENDOR_ID, 7, 2);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 4, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 21, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_BEAR_VENDOR_ID, 11, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 7, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 8, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 6, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 16, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 17, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 25, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 13, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 30, 1);
        set.add(supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(F_LIME_VENDOR_ID, 33, 1);
        set.add(supportedMessageBlock);
        return set;
    }

    public int supportsMessage(byte[] byArray, int n) {
        for (SupportedMessageBlock supportedMessageBlock : this._messagesSupported) {
            int n2 = supportedMessageBlock.matches(byArray, n);
            if (n2 <= -1) continue;
            return n2;
        }
        return -1;
    }

    public int supportsTCPConnectBack() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBack() {
        return this.supportsMessage(F_GTKG_VENDOR_ID, 7);
    }

    public int supportsTCPConnectBackRedirect() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBackRedirect() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 8);
    }

    public int supportsHopsFlow() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 4);
    }

    public int supportsPushProxy() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 21);
    }

    public int supportsLeafGuidance() {
        return this.supportsMessage(F_BEAR_VENDOR_ID, 11);
    }

    public int supportsUDPCrawling() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 6);
    }

    public int supportsHeaderUpdate() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 25);
    }

    public int supportsOOBProxyingControl() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 13);
    }

    public int supportsInspectionRequests() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 30);
    }

    public int supportsDHTContacts() {
        return this.supportsMessage(F_LIME_VENDOR_ID, 33);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof MessagesSupportedVendorMessage) {
            MessagesSupportedVendorMessage messagesSupportedVendorMessage = (MessagesSupportedVendorMessage)object;
            return ((Object)this._messagesSupported).equals(messagesSupportedVendorMessage._messagesSupported);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * ((Object)this._messagesSupported).hashCode();
    }

    @Override
    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    static class SupportedMessageBlock {
        final byte[] _vendorID;
        final int _selector;
        final int _version;
        final int _hashCode;

        public SupportedMessageBlock(byte[] byArray, int n, int n2) {
            this._vendorID = byArray;
            this._selector = n;
            this._version = n2;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public SupportedMessageBlock(InputStream inputStream) throws BadPacketException, IOException {
            if (inputStream.available() < 8) {
                throw new BadPacketException("invalid data.");
            }
            this._vendorID = new byte[4];
            inputStream.read(this._vendorID, 0, this._vendorID.length);
            this._selector = ByteOrder.ushort2int(ByteOrder.leb2short(inputStream));
            this._version = ByteOrder.ushort2int(ByteOrder.leb2short(inputStream));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this._vendorID);
            ByteOrder.short2leb((short)this._selector, outputStream);
            ByteOrder.short2leb((short)this._version, outputStream);
        }

        public int matches(byte[] byArray, int n) {
            if (Arrays.equals(this._vendorID, byArray) && this._selector == n) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (object instanceof SupportedMessageBlock) {
                SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)object;
                return this._selector == supportedMessageBlock._selector && this._version == supportedMessageBlock._version && Arrays.equals(this._vendorID, supportedMessageBlock._vendorID);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] byArray, int n, int n2) {
            int n3 = 0;
            n3 += 37 * n2;
            n3 += 37 * n;
            for (int i = 0; i < byArray.length; ++i) {
                n3 += 37 * byArray[i];
            }
            return n3;
        }
    }
}

