/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.util.DataUtils;

public class OOBProxyControlVendorMessage
extends AbstractVendorMessage {
    public static final int VERSION = 1;

    public OOBProxyControlVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 13, n, byArray2, network);
        if (this.getVersion() != 1) {
            throw new BadPacketException("Unsupported version or payload length");
        }
    }

    public OOBProxyControlVendorMessage(Control control) {
        super(F_LIME_VENDOR_ID, 13, 1, OOBProxyControlVendorMessage.derivePayload(control));
    }

    private static byte[] derivePayload(Control control) {
        if (control == Control.DISABLE_FOR_ALL_VERSIONS) {
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
        return new byte[]{(byte)control.getVersion()};
    }

    public static OOBProxyControlVendorMessage createDoNotProxyMessage() {
        return new OOBProxyControlVendorMessage(Control.DISABLE_FOR_ALL_VERSIONS);
    }

    public static OOBProxyControlVendorMessage createDoProxyMessage() {
        return new OOBProxyControlVendorMessage(Control.ENABLE_FOR_ALL_VERSIONS);
    }

    public int getMaximumDisabledVersion() {
        byte[] byArray = this.getPayload();
        if (byArray.length == 0) {
            return Integer.MAX_VALUE;
        }
        return byArray[0] & 0xFF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Control {
        DISABLE_FOR_ALL_VERSIONS(-1),
        ENABLE_FOR_ALL_VERSIONS(0),
        DISABLE_VERSION_1(1),
        DISABLE_VERSION_2(2),
        DISABLE_VERSION_3(3),
        DISABLE_VERSION_255(255);

        private int version;

        private Control(int n2) {
            if (n2 > 255) {
                throw new IllegalArgumentException("version must be smaller than 256");
            }
            this.version = n2;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

