/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteOrder;

public final class QueryStatusResponse
extends AbstractVendorMessage {
    public static final int VERSION = 1;

    QueryStatusResponse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_BEAR_VENDOR_ID, 12, n, byArray2, network);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public QueryStatusResponse(GUID gUID, int n) {
        super(F_BEAR_VENDOR_ID, 12, 1, QueryStatusResponse.derivePayload(n));
        this.setGUID(gUID);
    }

    public int getNumResults() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this.getPayload(), 0));
    }

    public GUID getQueryGUID() {
        return new GUID(this.getGUID());
    }

    private static byte[] derivePayload(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Number of results too big: " + n);
        }
        byte[] byArray = new byte[2];
        ByteOrder.short2leb((short)n, byArray, 0);
        return byArray;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }
}

