/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.messages.vendor.VendorMessageParserBinder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntHashMap;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class VendorMessageFactoryImpl
implements VendorMessageFactory {
    private static final Log LOG = LogFactory.getLog(VendorMessageFactoryImpl.class);
    private static final Comparator<byte[]> COMPARATOR = new ByteArrayComparator();
    private volatile Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> VENDORS = new TreeMap<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>>(COMPARATOR);
    private static final BadPacketException UNRECOGNIZED_EXCEPTION = new BadPacketException("Unrecognized Vendor Message");

    public VendorMessageFactoryImpl() {
    }

    @Inject
    public VendorMessageFactoryImpl(VendorMessageParserBinder vendorMessageParserBinder) {
        vendorMessageParserBinder.bind(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParser(int n, byte[] byArray, VendorMessageFactory.VendorMessageParser vendorMessageParser) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Selector is out of range: " + n);
        }
        if (byArray == null) {
            throw new NullPointerException("Vendor ID is null");
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Vendor ID must be 4 bytes long");
        }
        if (vendorMessageParser == null) {
            throw new NullPointerException("VendorMessageParser is null");
        }
        VendorMessageFactory.VendorMessageParser vendorMessageParser2 = null;
        Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> map = this.VENDORS;
        synchronized (map) {
            Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> map2 = this.copyVendors();
            IntHashMap<VendorMessageFactory.VendorMessageParser> intHashMap = map2.get(byArray);
            if (intHashMap == null) {
                intHashMap = new IntHashMap();
                map2.put(byArray, intHashMap);
            }
            vendorMessageParser2 = intHashMap.put(n, vendorMessageParser);
            this.VENDORS = map2;
        }
        if (vendorMessageParser2 != null && LOG.isErrorEnabled()) {
            LOG.error("There was already a VendorMessageParser of type " + vendorMessageParser2.getClass() + " registered for selector " + n);
        }
    }

    private Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> copyVendors() {
        TreeMap<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> treeMap = new TreeMap<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>>(COMPARATOR);
        for (Map.Entry<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> entry : this.VENDORS.entrySet()) {
            treeMap.put(entry.getKey(), new IntHashMap<VendorMessageFactory.VendorMessageParser>(entry.getValue()));
        }
        return treeMap;
    }

    @Override
    public VendorMessageFactory.VendorMessageParser getParser(int n, byte[] byArray) {
        IntHashMap<VendorMessageFactory.VendorMessageParser> intHashMap = this.VENDORS.get(byArray);
        if (intHashMap == null) {
            return null;
        }
        return intHashMap.get(n);
    }

    @Override
    public VendorMessage deriveVendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
        if (byArray2.length < 8) {
            throw new BadPacketException("Not enough bytes for a VM!!");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n = -1;
        int n2 = -1;
        try {
            byArray3 = new byte[4];
            byteArrayInputStream.read(byArray3, 0, byArray3.length);
            n = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
            n2 = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
            byArray4 = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(byArray4, 0, byArray4.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        VendorMessageFactory.VendorMessageParser vendorMessageParser = this.getParser(n, byArray3);
        if (vendorMessageParser == null) {
            throw UNRECOGNIZED_EXCEPTION;
        }
        return vendorMessageParser.parse(byArray, by, by2, n2, byArray4, network);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArrayComparator
    implements Comparator<byte[]> {
        private ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n = (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
                if (n < 0) {
                    return -1;
                }
                if (n <= 0) continue;
                return 1;
            }
            return 0;
        }
    }
}

