/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.reader.ASFParser;
import com.limegroup.gnutella.metadata.video.VideoMetaData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMVMetaData
implements MetaReader {
    private final VideoMetaData videoData = new VideoMetaData();

    public WMVMetaData(File file) throws IOException {
        this.parseFile(file);
    }

    public WMVMetaData(ASFParser aSFParser) throws IOException {
        this.set(aSFParser);
    }

    protected void parseFile(File file) throws IOException {
        ASFParser aSFParser = new ASFParser(file);
        this.set(aSFParser);
    }

    private void set(ASFParser aSFParser) throws IOException {
        if (!aSFParser.hasVideo()) {
            throw new IOException("no video data!");
        }
        this.videoData.setTitle(aSFParser.getTitle());
        this.videoData.setYear(aSFParser.getYear());
        this.videoData.setComment(aSFParser.getComment());
        this.videoData.setLength(aSFParser.getLength());
        this.videoData.setWidth(aSFParser.getWidth());
        this.videoData.setHeight(aSFParser.getHeight());
        if (aSFParser.getLicenseInfo() != null) {
            this.videoData.setLicenseType(aSFParser.getLicenseInfo());
        }
    }

    @Override
    public MetaData getMetaData() {
        return this.videoData;
    }

    @Override
    public String getSchemaURI() {
        return this.videoData.getSchemaURI();
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        return this.videoData.toNameValueList();
    }
}

