/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.rudp.messages.LimeAckMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeDataMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeFinMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeKeepAliveMessageImpl;
import com.limegroup.gnutella.rudp.messages.LimeSynMessageImpl;
import java.nio.ByteBuffer;
import org.limewire.rudp.messages.AckMessage;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.FinMessage;
import org.limewire.rudp.messages.KeepAliveMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.SynMessage;

@Singleton
class LimeRUDPMessageFactory
implements RUDPMessageFactory {
    private final RUDPMessageFactory delegate;

    @Inject
    public LimeRUDPMessageFactory(@Named(value="delegate") RUDPMessageFactory rUDPMessageFactory) {
        if (rUDPMessageFactory == null) {
            throw new NullPointerException("Delegate is null");
        }
        if (rUDPMessageFactory instanceof LimeRUDPMessageFactory) {
            throw new IllegalArgumentException("Recursive delegation");
        }
        this.delegate = rUDPMessageFactory;
    }

    RUDPMessageFactory getDelegate() {
        return this.delegate;
    }

    public RUDPMessage createMessage(ByteBuffer ... byteBufferArray) throws MessageFormatException {
        RUDPMessage rUDPMessage = this.delegate.createMessage(byteBufferArray);
        if (rUDPMessage instanceof AckMessage) {
            return new LimeAckMessageImpl((AckMessage)rUDPMessage);
        }
        if (rUDPMessage instanceof DataMessage) {
            return new LimeDataMessageImpl((DataMessage)rUDPMessage);
        }
        if (rUDPMessage instanceof FinMessage) {
            return new LimeFinMessageImpl((FinMessage)rUDPMessage);
        }
        if (rUDPMessage instanceof KeepAliveMessage) {
            return new LimeKeepAliveMessageImpl((KeepAliveMessage)rUDPMessage);
        }
        if (rUDPMessage instanceof SynMessage) {
            return new LimeSynMessageImpl((SynMessage)rUDPMessage);
        }
        throw new IllegalArgumentException(rUDPMessage.getClass() + " is unhandled");
    }

    public AckMessage createAckMessage(byte by, long l, long l2, int n) {
        return new LimeAckMessageImpl(this.delegate.createAckMessage(by, l, l2, n));
    }

    public DataMessage createDataMessage(byte by, long l, ByteBuffer byteBuffer) {
        return new LimeDataMessageImpl(this.delegate.createDataMessage(by, l, byteBuffer));
    }

    public FinMessage createFinMessage(byte by, long l, byte by2) {
        return new LimeFinMessageImpl(this.delegate.createFinMessage(by, l, by2));
    }

    public KeepAliveMessage createKeepAliveMessage(byte by, long l, int n) {
        return new LimeKeepAliveMessageImpl(this.delegate.createKeepAliveMessage(by, l, n));
    }

    public SynMessage createSynMessage(byte by) {
        return new LimeSynMessageImpl(this.delegate.createSynMessage(by));
    }

    public SynMessage createSynMessage(byte by, byte by2) {
        return new LimeSynMessageImpl(this.delegate.createSynMessage(by, by2));
    }
}

