/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.QueryHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProbeQuery {
    private final List<RoutedConnection> TTL_1_PROBES;
    private final List<RoutedConnection> TTL_2_PROBES;
    private final QueryHandler QUERY_HANDLER;

    ProbeQuery(List<? extends RoutedConnection> list, QueryHandler queryHandler) {
        this.QUERY_HANDLER = queryHandler;
        List<List<RoutedConnection>> list2 = ProbeQuery.createProbeLists(list, queryHandler.getTemplateQueryRequest());
        this.TTL_1_PROBES = list2.get(0);
        this.TTL_2_PROBES = list2.get(1);
    }

    long getTimeToWait() {
        if (!this.TTL_2_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * 1.3);
        }
        if (!this.TTL_1_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * ((double)this.TTL_1_PROBES.size() / 2.0));
        }
        return 0L;
    }

    int sendProbe() {
        int n = 0;
        QueryRequest queryRequest = this.QUERY_HANDLER.createQuery((byte)1);
        for (RoutedConnection routedConnection : this.TTL_1_PROBES) {
            n += this.QUERY_HANDLER.sendQueryToHost(queryRequest, routedConnection);
        }
        queryRequest = this.QUERY_HANDLER.createQuery((byte)2);
        for (RoutedConnection routedConnection : this.TTL_2_PROBES) {
            n += this.QUERY_HANDLER.sendQueryToHost(queryRequest, routedConnection);
        }
        this.TTL_1_PROBES.clear();
        this.TTL_2_PROBES.clear();
        return n;
    }

    private static List<List<RoutedConnection>> createProbeLists(List<? extends RoutedConnection> list, QueryRequest queryRequest) {
        boolean bl;
        LinkedList<RoutedConnection> linkedList = new LinkedList<RoutedConnection>();
        LinkedList<RoutedConnection> linkedList2 = new LinkedList<RoutedConnection>();
        LinkedList<RoutedConnection> linkedList3 = new LinkedList<RoutedConnection>();
        for (RoutedConnection object2 : list) {
            if (object2.getConnectionCapabilities().isUltrapeerQueryRoutingConnection()) {
                if (object2.shouldForwardQuery(queryRequest)) {
                    linkedList3.add(object2);
                    continue;
                }
                linkedList.add(object2);
                continue;
            }
            linkedList2.add(object2);
        }
        ArrayList arrayList = new ArrayList(2);
        LinkedList linkedList4 = new LinkedList();
        LinkedList linkedList5 = new LinkedList();
        arrayList.add(linkedList4);
        arrayList.add(linkedList5);
        boolean bl2 = bl = linkedList.size() + linkedList3.size() > 8;
        if (linkedList3.size() == 0 || !bl) {
            return ProbeQuery.createAggressiveProbe(linkedList2, linkedList, linkedList3, arrayList);
        }
        int n = linkedList3.size();
        double d = (double)n / ((double)linkedList.size() + (double)n);
        if (d == 1.0) {
            linkedList4.add(linkedList3.removeFirst());
            return arrayList;
        }
        if (n > 3) {
            int n2 = Math.min(9, n);
            int n3 = n - n2;
            int n4 = n;
            linkedList4.addAll(linkedList3.subList(n3, n4));
            return arrayList;
        }
        linkedList4.addAll(linkedList3);
        ProbeQuery.addToList(linkedList5, linkedList2, linkedList, 3);
        return arrayList;
    }

    private static <T> void addToList(List<T> list, List<? extends T> list2, List<? extends T> list3, int n) {
        if (list2.size() >= n) {
            list.addAll(list2.subList(0, n));
            return;
        }
        list.addAll(list2);
        if (list3.size() >= (n -= list2.size())) {
            list.addAll(list3.subList(0, n));
        } else {
            list.addAll(list3);
        }
    }

    private static <T> List<List<T>> createAggressiveProbe(List<? extends T> list, List<? extends T> list2, List<? extends T> list3, List<List<T>> list4) {
        ProbeQuery.addToList(list4.get(1), list, list2, 3);
        int n = Math.min(4, list3.size());
        list4.get(0).addAll(list3.subList(0, n));
        return list4;
    }
}

