/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.ByteSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.PowerOfTwoSetting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetting;

public final class ConnectionSettings
extends LimeProps {
    public static final int C_NO_PROXY = 0;
    public static final int C_SOCKS4_PROXY = 4;
    public static final int C_SOCKS5_PROXY = 5;
    public static final int C_HTTP_PROXY = 1;
    public static final BooleanSetting EVER_ACCEPTED_INCOMING = FACTORY.createBooleanSetting("EVER_ACCEPTED_INCOMING", false);
    public static final BooleanSetting LAST_FWT_STATE = FACTORY.createExpirableBooleanSetting("LAST_FWT_STATE", false);
    public static final BooleanSetting CONNECT_ON_STARTUP = FACTORY.createBooleanSetting("CONNECT_ON_STARTUP", true);
    public static final IntSetting NUM_CONNECTIONS = FACTORY.createRemoteIntSetting("NUM_CONNECTIONS", 32, "ConnectionSettings.numConnections", 16, 96);
    public static final FloatSetting MAX_NON_LIME_PEERS = FACTORY.createRemoteFloatSetting("MAX_NON_LIME_PEERS", 0.5f, "ConnectionSettings.maxLimePeers", 0.0f, 0.5f);
    public static final FloatSetting MIN_NON_LIME_PEERS = FACTORY.createRemoteFloatSetting("MIN_NON_LIME_PEERS", 0.1f, "ConnectionSettings.minLimePeers", 0.0f, 0.2f);
    public static final ByteSetting SOFT_MAX = FACTORY.createRemoteByteSetting("SOFT_MAX", (byte)3, "ConnectionSettings.softMax", (byte)3, (byte)5);
    public static final BooleanSetting LOCAL_IS_PRIVATE = FACTORY.createBooleanSetting("LOCAL_IS_PRIVATE", true);
    public static final BooleanSetting FILTER_CLASS_C = FACTORY.createBooleanSetting("FILTER_CLASS_C", true);
    public static final BooleanSetting ALLOW_DUPLICATE = FACTORY.createBooleanSetting("ALLOW_DUPLICATE", false);
    public static final BooleanSetting WATCHDOG_ACTIVE = FACTORY.createBooleanSetting("WATCHDOG_ACTIVE", true);
    public static final StringSetting MULTICAST_ADDRESS = FACTORY.createStringSetting("MULTICAST_ADDRESS", "234.21.81.1");
    public static final IntSetting MULTICAST_PORT = FACTORY.createIntSetting("MULTICAST_PORT", 6347);
    public static final BooleanSetting ALLOW_MULTICAST_LOOPBACK = FACTORY.createBooleanSetting("ALLOW_MULTICAST_LOOPBACK", false);
    public static final BooleanSetting PREFERENCING_ACTIVE = FACTORY.createBooleanSetting("PREFERENCING_ACTIVE", true);
    public static final BooleanSetting ALLOW_WHILE_DISCONNECTED = FACTORY.createBooleanSetting("ALLOW_WHILE_DISCONNECTED", false);
    public static final BooleanSetting REMOVE_ENABLED = FACTORY.createBooleanSetting("REMOVE_ENABLED", true);
    public static BooleanSetting SEND_QRP = FACTORY.createBooleanSetting("SEND_QRP", true);
    public static final BooleanSetting ACCEPT_DEFLATE = FACTORY.createBooleanSetting("ACCEPT_GNUTELLA_DEFLATE", true);
    public static final BooleanSetting ENCODE_DEFLATE = FACTORY.createBooleanSetting("ENCODE_GNUTELLA_DEFLATE", true);
    public static final ByteSetting TTL = FACTORY.createByteSetting("TTL", (byte)5);
    public static final IntSetting CONNECTION_SPEED = FACTORY.createIntSetting("CONNECTION_SPEED", 350);
    public static final IntSetting PORT = FACTORY.createIntSetting("PORT", 6346);
    public static final BooleanSetting FORCE_IP_ADDRESS = FACTORY.createBooleanSetting("FORCE_IP_ADDRESS", false);
    public static final StringSetting FORCED_IP_ADDRESS_STRING = (StringSetting)FACTORY.createStringSetting("FORCED_IP_ADDRESS_STRING", "0.0.0.0").setPrivate(true);
    public static final IntSetting FORCED_PORT = FACTORY.createIntSetting("FORCED_PORT", 6346);
    @InspectablePrimitive(value="disable upnp setting")
    public static final BooleanSetting DISABLE_UPNP = FACTORY.createBooleanSetting("DISABLE_UPNP", false);
    @InspectablePrimitive(value="upnp in use setting")
    public static final BooleanSetting UPNP_IN_USE = FACTORY.createBooleanSetting("UPNP_IN_USE", true);
    public static final String CONNECT_STRING_FIRST_WORD = "GNUTELLA";
    public static final StringSetting CONNECT_STRING = FACTORY.createStringSetting("CONNECT_STRING", "GNUTELLA CONNECT/0.4");
    public static final StringSetting CONNECT_OK_STRING = FACTORY.createStringSetting("CONNECT_OK_STRING", "GNUTELLA OK");
    public static final BooleanSetting CUSTOM_NETWORK_INTERFACE = FACTORY.createBooleanSetting("CUSTOM_NETWORK_INTERFACE", false);
    public static final StringSetting CUSTOM_INETADRESS = FACTORY.createStringSetting("CUSTOM_INETADRESS_TO_BIND", "0.0.0.0");
    public static final StringSetting PROXY_HOST = FACTORY.createStringSetting("PROXY_HOST", "");
    public static final IntSetting PROXY_PORT = FACTORY.createIntSetting("PROXY_PORT", 0);
    public static final BooleanSetting USE_PROXY_FOR_PRIVATE = FACTORY.createBooleanSetting("USE_PROXY_FOR_PRIVATE", false);
    public static final IntSetting CONNECTION_METHOD = FACTORY.createIntSetting("CONNECTION_TYPE", 0);
    public static final BooleanSetting PROXY_AUTHENTICATE = FACTORY.createBooleanSetting("PROXY_AUTHENTICATE", false);
    public static final StringSetting PROXY_USERNAME = FACTORY.createStringSetting("PROXY_USERNAME", "");
    public static final StringSetting PROXY_PASS = FACTORY.createStringSetting("PROXY_PASS", "");
    public static final BooleanSetting USE_LOCALE_PREF = FACTORY.createBooleanSetting("USE_LOCALE_PREF", true);
    public static final IntSetting NUM_LOCALE_PREF = FACTORY.createIntSetting("NUMBER_LOCALE_PREF", 2);
    public static final IntSetting LIME_ATTEMPTS = FACTORY.createIntSetting("LIME_ATTEMPTS", 40);
    public static final LongSetting SOLICITED_GRACE_PERIOD = FACTORY.createLongSetting("SOLICITED_GRACE_PERIOD", 85000L);
    public static final IntSetting NUM_RETURN_PONGS = FACTORY.createRemoteIntSetting("NUM_RETURN_PONGS", 10, "pings", 5, 25);
    public static final IntSetting DHT_TO_GNUT_HOSTS_PONG = FACTORY.createRemoteIntSetting("DHT_TO_GNUT_HOSTS_PONG", 50, "dht_gnutella_hosts_pong", 0, 100);
    public static final BooleanSetting DO_NOT_BOOTSTRAP = FACTORY.createBooleanSetting("DO_NOT_BOOTSTRAP", false);
    public static final BooleanSetting DO_NOT_MULTICAST_BOOTSTRAP = FACTORY.createBooleanSetting("DO_NOT_MULTICAST_BOOTSTRAP", false);
    public static final LongSetting FLUSH_DELAY_TIME = FACTORY.createRemoteLongSetting("FLUSH_DELAY_TIME", 0L, "flushdelay", 0L, 300L);
    public static final StringArraySetting EVIL_HOSTS = FACTORY.createRemoteStringArraySetting("EVIL_HOSTS", new String[0], "evil_hosts");
    public static final IntSetting IDLE_CONNECTIONS = FACTORY.createRemoteIntSetting("IDLE_CONNECTIONS", 2, "ConnectionSettings.IdleConnections", 1, 3);
    public static final IntSetting MAX_HANDSHAKE_LINE_SIZE = FACTORY.createRemoteIntSetting("MAX_HANDSHAKE_LINE_SIZE", 1024, "handshake.maxLineSize", 512, 4096);
    public static final IntSetting MAX_HANDSHAKE_HEADERS = FACTORY.createRemoteIntSetting("MAX_HANDSHAKZE_LIMIT", 30, "handshake.maxHeaderLimit", 15, 100);
    public static final PowerOfTwoSetting QRT_SIZE_IN_KIBI_ENTRIES = FACTORY.createRemotePowerOfTwoSetting("QRT_SIZE_IN_KIBI_ENTRIES", 128L, "ConnectionSettings.QRTSize", 128L, 256L);
    public static final IntSetting STABLE_PERCONNECT_MESSAGES_THRESHOLD = FACTORY.createIntSetting("STABLE_MESSAGES_THRESHOLD", 5);
    public static final IntSetting STABLE_TOTAL_MESSAGES_THRESHOLD = FACTORY.createIntSetting("STABLE_TOTAL_MESSAGES_THRESHOLD", 45);

    private ConnectionSettings() {
    }

    public static final int getMaxConnections() {
        int n = CONNECTION_SPEED.getValue();
        if (n <= 56) {
            return 3;
        }
        if (n <= 350) {
            return 6;
        }
        if (n <= 1000) {
            return 10;
        }
        if (n >= 3000) {
            return 24;
        }
        return 24;
    }
}

