/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FileSetSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingSettings
extends LimeProps {
    private static final Hashtable<String, FileSetting> downloadDirsByDescription = new Hashtable();
    public static final File DEFAULT_SAVE_DIR = new File(LimeWireUtils.getLimeWireRootFolder(), "Saved");
    public static final File DEFAULT_SHARE_DIR = new File(LimeWireUtils.getLimeWireRootFolder(), "Shared");
    public static final File DEFAULT_SHARED_TORRENTS_DIR = new File(LimeWireUtils.getLimeWireRootFolder(), "Torrents");
    public static final File DEFAULT_SAVE_LWS_DIR = new File(LimeWireUtils.getLimeWireRootFolder(), "Store Purchased");
    public static final BooleanSetting ADD_ALTERNATE_FOR_SELF = FACTORY.createBooleanSetting("ADD_ALTERNATE_FOR_SELF", true);
    public static final FileSetting DIRECTORY_FOR_SAVING_FILES = FACTORY.createFileSetting("DIRECTORY_FOR_SAVING_FILES", DEFAULT_SAVE_DIR).setAlwaysSave(true);
    public static final FileSetting DIRECTORY_FOR_SAVING_LWS_FILES = FACTORY.createFileSetting("DIRETORY_FOR_SAVING_LWS_FILES", DEFAULT_SAVE_LWS_DIR).setAlwaysSave(true);
    public static final StringSetting TEMPLATE_FOR_SAVING_LWS_FILES = (StringSetting)FACTORY.createStringSetting("TEMPLATE_FOR_SAVING_LWS_FILES", "").setAlwaysSave(true);
    public static final FileSetting INCOMPLETE_DIRECTORY = FACTORY.createFileSetting("INCOMPLETE_DIRECTORY", new File(DIRECTORY_FOR_SAVING_FILES.getValue().getParent(), "Incomplete"));
    public static final FileSetting OLD_DOWNLOAD_SNAPSHOT_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.dat"));
    public static final FileSetting OLD_DOWNLOAD_SNAPSHOT_BACKUP_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_BACKUP_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.bak"));
    public static final IntSetting INCOMPLETE_PURGE_TIME = FACTORY.createIntSetting("INCOMPLETE_PURGE_TIME", 7);
    public static final IntSetting TORRENT_METADATA_PURGE_TIME = FACTORY.createIntSetting("TORRENT_METADATA_PURGE_TIME", 7);
    public static final BooleanSetting CLEAR_DOWNLOAD = FACTORY.createBooleanSetting("CLEAR_DOWNLOAD", false);
    private static final String DEFAULT_EXTENSIONS_TO_SHARE = "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;aif;aiff;ra;ram;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;flac;fla;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;fwtp;lwtp;pmf;m4a;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;deb;pkg;sxw;l6t;srt;sub;idx;mkv;ogm;shn;dvi;rmvp;kar;cdg;ccd;cue;c;h;m;java;jar;pl;py;pyc;pyo;pyz";
    private static final String DEFAULT_EXTENSIONS_TO_DISABLE = "au;doc;pdf;xls;rtf;bak;csv;dat;docx;xlsx;xlam;xltx;xltm;xlsm;xlsb;dotm;docm;dotx;dot;qdf;qtx;qph;qel;qdb;qsd;qif;mbf;mny;wma";
    public static final FileSetSetting DIRECTORIES_TO_SHARE = FACTORY.createFileSetSetting("DIRECTORIES_TO_SEARCH_FOR_FILES", new File[0]);
    public static final BooleanSetting SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES = FACTORY.createBooleanSetting("SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES", true);
    public static final BooleanSetting SHARE_TORRENT_META_FILES = FACTORY.createBooleanSetting("SHARE_TORRENT_META_FILES", true);
    public static final BooleanSetting SHOW_TORRENT_META_FILES = FACTORY.createBooleanSetting("SHOW_TORRENT_META_FILES", true);
    public static final StringSetting EXTENSIONS_TO_SHARE = FACTORY.createStringSetting("EXTENSIONS_TO_SEARCH_FOR", "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;aif;aiff;ra;ram;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;flac;fla;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;fwtp;lwtp;pmf;m4a;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;deb;pkg;sxw;l6t;srt;sub;idx;mkv;ogm;shn;dvi;rmvp;kar;cdg;ccd;cue;c;h;m;java;jar;pl;py;pyc;pyo;pyz");
    public static final BooleanSetting EXTENSIONS_MIGRATE = FACTORY.createBooleanSetting("EXTENSIONS_MIGRATE", true);
    public static final StringSetting EXTENSIONS_LIST_CUSTOM = FACTORY.createStringSetting("EXTENSIONS_LIST_CUSTOM", "");
    public static final StringSetting EXTENSIONS_LIST_UNSHARED = FACTORY.createStringSetting("EXTENSIONS_LIST_UNSHARED", "");
    public static final BooleanSetting DISABLE_SENSITIVE = FACTORY.createBooleanSetting("DISABLE_SENSITIVE_EXTS", true);
    public static final IntSetting FREELOADER_ALLOWED = FACTORY.createIntSetting("FREELOADER_ALLOWED", 100);
    public static final IntSetting FREELOADER_FILES = FACTORY.createIntSetting("FREELOADER_FILES", 1);
    public static final IntSetting PERSISTENT_HTTP_CONNECTION_TIMEOUT = FACTORY.createIntSetting("PERSISTENT_HTTP_CONNECTION_TIMEOUT", 15000);
    public static final BooleanSetting CLEAR_UPLOAD = FACTORY.createBooleanSetting("CLEAR_UPLOAD", true);
    public static final BooleanSetting ALLOW_BROWSER = FACTORY.createBooleanSetting("ALLOW_BROWSER", false);
    public static final BooleanSetting FRIENDLY_HASHING = FACTORY.createBooleanSetting("FRIENDLY_HASHING", true);
    public static final IntSetting FILES_FOR_WARNING = FACTORY.createIntSetting("FILES_FOR_WARNING", 1000);
    public static final IntSetting DEPTH_FOR_WARNING = FACTORY.createIntSetting("DEPTH_FOR_WARNING", 4);
    public static final StringSetting CREATIVE_COMMONS_INTRO_URL = FACTORY.createRemoteStringSetting("CREATIVE_COMMONS_URL", "http://creativecommons.org/about/licenses/how1", "creativeCommonsURL");
    public static final StringSetting CREATIVE_COMMONS_VERIFICATION_URL = FACTORY.createRemoteStringSetting("CREATIVE_COMMONS_VERIFICATION_URL", "http://creativecommons.org/technology/embedding#2", "creativeCommonsVerificationURL");
    public static final BooleanSetting ALLOW_PARTIAL_SHARING = FACTORY.createBooleanSetting("ALLOW_PARTIAL_SHARING", true);
    public static final BooleanSetting ALLOW_PARTIAL_RESPONSES = FACTORY.createRemoteBooleanSetting("ALLOW_PARTIAL_RESPONSES", true, "SharingSettings.allowPartialResponses");
    public static final IntSetting MAX_PARTIAL_ENCODING_SIZE = FACTORY.createRemoteIntSetting("MAX_PARTIAL_ENCODING_SIZE", 20, "SharingSettings.maxPartialEncodingSize", 10, 40);
    public static final BooleanSetting PUBLISH_PARTIAL_QRP = FACTORY.createRemoteBooleanSetting("PUBLISH_PARTIAL_QRP", true, "SharingSettings.publishPartialQRP");
    public static final BooleanSetting LOAD_PARTIAL_KEYWORDS = FACTORY.createRemoteBooleanSetting("LOAD_PARTIAL_KEYWORDS", true, "SharingSettings.loadPartialKeywords");

    private SharingSettings() {
    }

    public static final void setSaveDirectory(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("could not create save dir");
        }
        String string = file.getParent();
        File file2 = new File(string, "Incomplete");
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IOException("could not create incomplete dir");
        }
        FileUtils.setWriteable(file);
        FileUtils.setWriteable(file2);
        if (!(file.canRead() && file.canWrite() && file2.canRead() && file2.canWrite())) {
            throw new IOException("could not write to selected directory");
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file2 = FileUtils.getCanonicalFile(file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file3 = new File(file2, "downloads.dat");
        try {
            file3 = FileUtils.getCanonicalFile(file3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file4 = new File(file2, "downloads.bak");
        try {
            file4 = FileUtils.getCanonicalFile(file4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_FILES.setValue(file);
        INCOMPLETE_DIRECTORY.setValue(file2);
        OLD_DOWNLOAD_SNAPSHOT_FILE.setValue(file3);
        OLD_DOWNLOAD_SNAPSHOT_BACKUP_FILE.setValue(file4);
    }

    public static final File getSaveDirectory(String string) {
        if (string == null) {
            return DIRECTORY_FOR_SAVING_FILES.getValue();
        }
        String string2 = FileUtils.getFileExtension(string);
        if (string2 == null) {
            return DIRECTORY_FOR_SAVING_FILES.getValue();
        }
        MediaType mediaType = MediaType.getMediaTypeForExtension(string2);
        if (mediaType == null) {
            return DIRECTORY_FOR_SAVING_FILES.getValue();
        }
        FileSetting fileSetting = SharingSettings.getFileSettingForMediaType(mediaType);
        if (fileSetting.isDefault()) {
            return DIRECTORY_FOR_SAVING_FILES.getValue();
        }
        return fileSetting.getValue();
    }

    public static final File getSaveDirectory() {
        return DIRECTORY_FOR_SAVING_FILES.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<File> getAllSaveDirectories() {
        HashSet<File> hashSet = new HashSet<File>(7);
        hashSet.add(SharingSettings.getSaveDirectory());
        Hashtable<String, FileSetting> hashtable = downloadDirsByDescription;
        synchronized (hashtable) {
            for (FileSetting fileSetting : downloadDirsByDescription.values()) {
                hashSet.add(fileSetting.getValue());
            }
        }
        return hashSet;
    }

    public static final void setSaveLWSDirectory(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("could not create save dir at: " + file);
        }
        FileUtils.setWriteable(file);
        if (!file.canRead() || !file.canWrite()) {
            throw new IOException("could not write to selected directory");
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_LWS_FILES.setValue(file);
    }

    public static final File getSaveLWSDirectory(File file) {
        return DIRECTORY_FOR_SAVING_LWS_FILES.getValue();
    }

    public static final File getSaveLWSDirectory() {
        File file = DIRECTORY_FOR_SAVING_LWS_FILES.getValue();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static final void setSaveLWSTemplate(String string) throws IOException {
        if (string == null) {
            string = "";
        }
        TEMPLATE_FOR_SAVING_LWS_FILES.setValue(string);
    }

    public static final String getSaveLWSTemplate() {
        return TEMPLATE_FOR_SAVING_LWS_FILES.getValue();
    }

    public static final String[] getDefaultExtensions() {
        return StringArraySetting.decode(DEFAULT_EXTENSIONS_TO_SHARE);
    }

    public static final String getDefaultExtensionsAsString() {
        return DEFAULT_EXTENSIONS_TO_SHARE;
    }

    public static final String[] getDefaultDisabledExtensions() {
        return StringArraySetting.decode(DEFAULT_EXTENSIONS_TO_DISABLE);
    }

    public static final String getDefaultDisabledExtensionsAsString() {
        return DEFAULT_EXTENSIONS_TO_DISABLE;
    }

    public static final FileSetting getFileSettingForMediaType(MediaType mediaType) {
        FileSetting fileSetting = downloadDirsByDescription.get(mediaType.getMimeType());
        if (fileSetting == null) {
            fileSetting = FACTORY.createProxyFileSetting("DIRECTORY_FOR_SAVING_" + mediaType.getMimeType() + "_FILES", DIRECTORY_FOR_SAVING_FILES);
            downloadDirsByDescription.put(mediaType.getMimeType(), fileSetting);
        }
        return fileSetting;
    }
}

