/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.setting.RemoteSettingController;
import org.limewire.setting.RemoteSettingManager;

public class SimppSettingsManager
implements RemoteSettingManager {
    private static final Log LOG = LogFactory.getLog(SimppSettingsManager.class);
    private final Properties _simppProps = new Properties();
    private final Map<String, String> _remainderSimppSettings = new HashMap<String, String>();
    private volatile RemoteSettingController _remoteController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSimppSettings(String string) {
        if (!ApplicationSettings.USE_SIMPP.getValue()) {
            System.out.println("SimppSettingsManager.updateSimppSettings() - No more SIMPP, turned off");
            return;
        }
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            byte[] byArray = null;
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorService.error(unsupportedEncodingException);
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this._simppProps.clear();
            try {
                this._simppProps.load(byteArrayInputStream);
            }
            catch (IOException iOException) {
                LOG.error("IOX reading simpp properties", iOException);
                return;
            }
            this.activateSimppSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSimppSettings() {
        System.out.println("SimppSettingsManager.activateSimppSettings() - activating new settings");
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            for (Map.Entry<Object, Object> entry : this._simppProps.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string.contains("SearchSettings.limeSearchTerms")) {
                    string2 = "frost;wire;frostwire;";
                }
                if (string.contains("SearchSettings.limeQRPEntries")) {
                    string2 = "frost;wire;frostwire";
                }
                if (string.contains("ResultPanel.SearchWarning")) {
                    string2 = "{0} Visit FrostWire.com for important updates.";
                }
                if (string.contains("ResultPanel.SearchBanner")) {
                    string2 = "  {0} Visit FrostWire.com for important updates.;http://www.frostwire.com/download;1.0f";
                }
                if (!string.contains("SWTBrowserSettings.remoteLimeWireStoreUrl")) continue;
                string2 = "http://www.frostwire.com";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnloadedValueFor(String string) {
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            return this._remainderSimppSettings.remove(string);
        }
    }

    public void setRemoteSettingController(RemoteSettingController remoteSettingController) {
        this._remoteController = remoteSettingController;
    }
}

