/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.SignatureVerifier;
import org.limewire.util.Base32;

public class SimppDataVerifier {
    private static final Log LOG = LogFactory.getLog(SimppDataVerifier.class);
    private static final byte SEP = 124;
    public final String DSA_ALGORITHM = "DSA";
    private byte[] simppPayload;
    private byte[] verifiedData;

    public SimppDataVerifier(byte[] byArray) {
        this.simppPayload = byArray;
    }

    public boolean verifySource() {
        int n = SimppDataVerifier.findSeperator(this.simppPayload);
        if (n < 0) {
            return false;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.simppPayload, 0, byArray, 0, n);
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        byte[] byArray2 = Base32.decode(string);
        byte[] byArray3 = new byte[this.simppPayload.length - 1 - n];
        System.arraycopy(this.simppPayload, n + 1, byArray3, 0, this.simppPayload.length - 1 - n);
        PublicKey publicKey = this.getPublicKey();
        if (publicKey == null) {
            return false;
        }
        String string2 = "DSA";
        SignatureVerifier signatureVerifier = new SignatureVerifier(byArray3, byArray2, publicKey, string2);
        boolean bl = signatureVerifier.verifySignature();
        if (bl) {
            this.verifiedData = byArray3;
        }
        return bl;
    }

    public byte[] getVerifiedData() {
        return this.verifiedData;
    }

    private PublicKey getPublicKey() {
        String string = "GCBADOBQQIASYBQHFKDERTRYAQATBAQBD4BIDAIA7V7VHAI5OUJCSUW7JKOC53HE473BDN2SHTXUIAGDDY7YBNSREZUUKXKAEJI7WWJ5RVMPVP6F6W5DB5WLTNKWZV4BHOAB2NDP6JTGBN3LTFIKLJE7T7UAI6YQELBE7O5J277LPRQ37A5VPZ6GVCTBKDYE7OB7NU6FD3BQENKUCNNBNEJS6Z27HLRLMHLSV37SEIBRTHORJAA4OAQVACLWAUEPCURQXTFSSK4YFIXLQQF7AWA46UBIDAIA67Q2BBOWTM655S54VNODNOCXXF4ZJL537I5OVAXZK5GAWPIHQJTVCWKXR25NIWKP4ZYQOEEBQC2ESFTREPUEYKAWCO346CJSRTEKNYJ4CZ5IWVD4RUUOBI5ODYV3HJTVSFXKG7YL7IQTKYXR7NRHUAJEHPGKJ4N6VBIZBCNIQPP6CWXFT4DJFC3GL2AHWVJFMQAUYO76Z5ESUA4BQUAAFAMBADZ2DEAUI6Y6O4SJOM6M77DVWGUD7SDOJZK7QACMEUF6BZLNEWUZ26IYVH53F4IPJBUGY4I7QVN5V7POFP7TLL2M6PCU4B66DO5DD7USVJABNT5PGI27G7BQD7OMRPRMOWYQHZUC6GXIW2X7HVSL5FBA5HMKZ6OTOXSAXJH2AUTSHXIM22DPNZVBOSK7UDJFBNMKCKHSRYHNUCY";
        byte[] byArray = Base32.decode(string);
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error("no algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOG.error("invalid key", invalidKeySpecException);
        }
        return publicKey;
    }

    static int findSeperator(byte[] byArray) {
        int n;
        boolean bl = false;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 124) continue;
            bl = true;
            break;
        }
        if (bl) {
            return n;
        }
        return -1;
    }
}

