/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SimppManager {
    private static final Log LOG = LogFactory.getLog(SimppManager.class);
    private static final String SIMPP_FILE = "simpp.xml";
    private static int MIN_VERSION = 3;
    private final List<SimppListener> listeners = new CopyOnWriteArrayList<SimppListener>();
    private volatile byte[] _simppBytes;
    private volatile String _propsStream;
    private final ExecutorService _processingQueue;
    private final CopyOnWriteArrayList<SimppSettingsManager> simppSettingsManagers;
    private volatile int _latestVersion;
    private Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject
    SimppManager(Provider<NetworkUpdateSanityChecker> provider) {
        this.networkUpdateSanityChecker = provider;
        this.simppSettingsManagers = new CopyOnWriteArrayList();
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        this._processingQueue = ExecutorsHelper.newProcessingQueue("Simpp Handling Queue");
        try {
            File file = new File(CommonUtils.getUserSettingsDir(), SIMPP_FILE);
            randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            SimppDataVerifier simppDataVerifier = new SimppDataVerifier(byArray);
            boolean bl2 = false;
            this._latestVersion = 0;
            bl2 = simppDataVerifier.verifySource();
            if (!bl2) {
                LOG.debug("Unable to verify simpp message.");
                bl = true;
                return;
            }
            SimppParser simppParser = null;
            try {
                simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
            }
            catch (IOException iOException) {
                LOG.error("IOX parsing simpp on disk", iOException);
                bl = true;
                if (bl) {
                    this._latestVersion = MIN_VERSION;
                    this._propsStream = "";
                    this._simppBytes = "".getBytes();
                }
                if (randomAccessFile == null) return;
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return;
            }
            if (simppParser.getVersion() <= MIN_VERSION) {
                LOG.error("Version below min on disk, aborting simpp.");
                bl = true;
                return;
            }
            this._latestVersion = simppParser.getVersion();
            this._propsStream = simppParser.getPropsData();
            this._simppBytes = byArray;
            return;
        }
        catch (IOException iOException) {
            LOG.error("IOX reading simpp xml on disk", iOException);
            bl = true;
            return;
        }
        finally {
            if (bl) {
                this._latestVersion = MIN_VERSION;
                this._propsStream = "";
                this._simppBytes = "".getBytes();
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getVersion() {
        return this._latestVersion;
    }

    public byte[] getSimppBytes() {
        return this._simppBytes;
    }

    public String getPropsString() {
        return this._propsStream;
    }

    public void checkAndUpdate(final ReplyHandler replyHandler, final byte[] byArray) {
        if (!ApplicationSettings.USE_SIMPP.getValue()) {
            System.out.println("SimppManager.checkAndUpdate() aborted - No more SIMPP, turned off");
            return;
        }
        if (byArray == null) {
            System.out.println("****SIMPPpayload IS CURRENTLY EMPTY*****");
            this.networkUpdateSanityChecker.get().handleInvalidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.SIMPP);
            return;
        }
        this.savefile(byArray, "checkandupdate.txt");
        final int n = this._latestVersion;
        Runnable runnable = new Runnable(){

            public void run() {
                SimppDataVerifier simppDataVerifier = new SimppDataVerifier(byArray);
                if (!simppDataVerifier.verifySource()) {
                    ((NetworkUpdateSanityChecker)SimppManager.this.networkUpdateSanityChecker.get()).handleInvalidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.SIMPP);
                    return;
                }
                ((NetworkUpdateSanityChecker)SimppManager.this.networkUpdateSanityChecker.get()).handleValidResponse(replyHandler, NetworkUpdateSanityChecker.RequestType.SIMPP);
                SimppParser simppParser = null;
                try {
                    simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
                }
                catch (IOException iOException) {
                    LOG.error("IOX parsing network simpp", iOException);
                    return;
                }
                int n2 = simppParser.getVersion();
                if (n2 <= n) {
                    LOG.error("Network simpp below current version, aborting.");
                    return;
                }
                SimppManager.this._latestVersion = n2;
                SimppManager.access$302(SimppManager.this, byArray);
                SimppManager.this._propsStream = simppParser.getPropsData();
                String string = simppParser.getPropsData();
                for (Object object : SimppManager.this.simppSettingsManagers) {
                    ((SimppSettingsManager)object).updateSimppSettings(string);
                }
                for (int i = 0; i < 5 && !SimppManager.this.save(); ++i) {
                }
                for (Object object : SimppManager.this.listeners) {
                    object.simppUpdated(n2);
                }
            }
        };
        this._processingQueue.execute(runnable);
    }

    public void addSimppSettingsManager(SimppSettingsManager simppSettingsManager) {
        this.simppSettingsManagers.add(simppSettingsManager);
    }

    public List<SimppSettingsManager> getSimppSettingsManagers() {
        return this.simppSettingsManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savefile(byte[] byArray, String string) {
        File file = new File(CommonUtils.getUserSettingsDir(), string);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        File file = new File(CommonUtils.getUserSettingsDir(), "simpp.xml.tmp");
        File file2 = new File(CommonUtils.getUserSettingsDir(), SIMPP_FILE);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream.write(this._simppBytes);
            outputStream.flush();
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        FilterInputStream filterInputStream = null;
        byte[] byArray = new byte[this._simppBytes.length];
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            ((DataInputStream)filterInputStream).readFully(byArray);
            if (!Arrays.equals(byArray, this._simppBytes)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return FileUtils.forceRename(file, file2);
    }

    public void addListener(SimppListener simppListener) {
        this.listeners.add(simppListener);
    }

    public void removeListener(SimppListener simppListener) {
        this.listeners.remove(simppListener);
    }

    static /* synthetic */ byte[] access$302(SimppManager simppManager, byte[] byArray) {
        simppManager._simppBytes = byArray;
        return byArray;
    }
}

