/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.spam.Token;
import java.util.Locale;

@Singleton
public class SpamManager {
    public static final float MAX_THRESHOLD = 0.995f;
    private static final float NO_SHA1_URN_RATING = 0.5f;
    private static final float INCOMPLETE_FILE_RATING = 0.2f;
    private final RatingTable ratingTable;

    @Inject
    SpamManager(RatingTable ratingTable) {
        this.ratingTable = ratingTable;
    }

    public void startedQuery(QueryRequest queryRequest) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            this.ratingTable.mark(queryRequest, Token.Rating.CLEARED);
        }
    }

    public boolean isSpam(RemoteFileDesc remoteFileDesc) {
        if (!SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            return false;
        }
        float f = 0.0f;
        if (remoteFileDesc.getSHA1Urn() == null && remoteFileDesc.getXMLDocument() != null && remoteFileDesc.getXMLDocument().getAction().length() == 0) {
            f = 1.0f - (1.0f - f) * 0.5f;
        }
        if (this.isIncompleteFile(remoteFileDesc.getFileName().toLowerCase(Locale.US))) {
            f = 1.0f - (1.0f - f) * 0.2f;
        }
        f = 1.0f - (1.0f - f) * (1.0f - this.ratingTable.getRating(remoteFileDesc));
        remoteFileDesc.setSpamRating(f);
        return f >= Math.max(SearchSettings.FILTER_SPAM_RESULTS.getValue(), SearchSettings.QUERY_SPAM_CUTOFF.getValue());
    }

    public void handleUserMarkedSpam(RemoteFileDesc[] remoteFileDescArray) {
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            remoteFileDescArray[i].setSpamRating(1.0f);
        }
        this.ratingTable.mark(remoteFileDescArray, Token.Rating.USER_MARKED_SPAM);
    }

    public void handleUserMarkedGood(RemoteFileDesc[] remoteFileDescArray) {
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            remoteFileDescArray[i].setSpamRating(0.0f);
        }
        this.ratingTable.mark(remoteFileDescArray, Token.Rating.USER_MARKED_GOOD);
    }

    public void clearFilterData() {
        this.ratingTable.clear();
    }

    private boolean isIncompleteFile(String string) {
        int n;
        if (string.startsWith("__incomplete")) {
            return true;
        }
        if (string.startsWith("___incompleted")) {
            return true;
        }
        if (string.startsWith("___arestra")) {
            return true;
        }
        if (string.startsWith("preview-t-")) {
            return true;
        }
        if (string.startsWith("t-")) {
            for (n = 2; n < string.length(); ++n) {
                if (Character.isDigit(string.charAt(n))) continue;
                return string.charAt(n) == '-';
            }
        }
        if (string.startsWith("corrupt-")) {
            for (n = 8; n < string.length(); ++n) {
                if (Character.isDigit(string.charAt(n))) continue;
                return string.charAt(n) == '-';
            }
        }
        return false;
    }
}

