/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.spam.AbstractToken;
import com.limegroup.gnutella.spam.Token;
import java.util.Arrays;

public class XMLKeywordToken
extends AbstractToken {
    private static final long serialVersionUID = 3617573808026760503L;
    private static final int MAX = 100;
    private final byte[] _keyword;
    private final byte[] _xmlField;
    private byte _good = (byte)90;
    private byte _bad = 0;
    private final int _hashCode;

    XMLKeywordToken(String string, byte[] byArray) {
        this._keyword = byArray;
        this._xmlField = string.getBytes();
        int n = string.hashCode();
        for (int i = 0; i < byArray.length; ++i) {
            n = 37 * n + byArray[i];
        }
        this._hashCode = n;
    }

    public float getRating() {
        return (float)Math.pow(1.0f * (float)this._bad / (float)(this._good + this._bad + 1), 2.0);
    }

    public void rate(Token.Rating rating) {
        this._age = 0;
        switch (rating) {
            case PROGRAM_MARKED_GOOD: {
                this._good = (byte)(this._good + 1);
                break;
            }
            case PROGRAM_MARKED_SPAM: {
                this._bad = (byte)(this._bad + 1);
                break;
            }
            case USER_MARKED_GOOD: {
                this._bad = 0;
                break;
            }
            case USER_MARKED_SPAM: {
                this._bad = (byte)Math.min(10 + this._bad, 100);
                break;
            }
            case CLEARED: {
                this._bad = 0;
                this._good = (byte)90;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of rating");
            }
        }
        if (this._good >= 100 || this._bad >= 100) {
            this._good = (byte)(this._good * 9 / 10);
            this._bad = (byte)(this._bad * 9 / 10);
        }
    }

    public Token.TokenType getType() {
        return Token.TokenType.XML_KEYWORD;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof XMLKeywordToken)) {
            return false;
        }
        if (this._hashCode != object.hashCode()) {
            return false;
        }
        return Arrays.equals(this._xmlField, ((XMLKeywordToken)object)._xmlField) && Arrays.equals(this._keyword, ((XMLKeywordToken)object)._keyword);
    }

    public String toString() {
        return new String(this._xmlField) + "::" + new String(this._keyword) + " : " + this._good + " : " + this._bad;
    }
}

