/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.google.inject.Singleton;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.inspection.InspectablePrimitive;

@Singleton
class OutOfBandStatisticsImpl
implements OutOfBandStatistics {
    private static final int START_MIN_SAMPLE_SIZE = 500;
    private static final int MIN_SUCCESS_RATE = 60;
    private static final int PROXY_SUCCESS_RATE = 80;
    private static final int TERRIBLE_SUCCESS_RATE = 40;
    @InspectablePrimitive(value="oob sample size")
    private AtomicInteger sampleSize = new AtomicInteger(500);
    @InspectablePrimitive(value="oob requested")
    private AtomicInteger requested = new AtomicInteger(0);
    @InspectablePrimitive(value="oob received")
    private AtomicInteger received = new AtomicInteger(0);
    @InspectablePrimitive(value="oob bypassed")
    private AtomicInteger bypassed = new AtomicInteger(0);
    @InspectablePrimitive(value="oob sent")
    private AtomicInteger sent = new AtomicInteger(0);

    OutOfBandStatisticsImpl() {
    }

    public void addBypassedResponse(int n) {
        this.bypassed.addAndGet(n);
    }

    public void addReceivedResponse(int n) {
        this.received.addAndGet(n);
    }

    public void addRequestedResponse(int n) {
        this.requested.addAndGet(n);
    }

    public void addSentQuery() {
        this.sent.incrementAndGet();
    }

    public int getRequestedResponses() {
        return this.requested.get();
    }

    public int getSampleSize() {
        return this.sampleSize.get();
    }

    public void increaseSampleSize() {
        this.sampleSize.addAndGet(500);
    }

    public double getSuccessRate() {
        double d = this.requested.doubleValue();
        double d2 = this.received.doubleValue();
        return d2 / d * 100.0;
    }

    public boolean isSuccessRateGood() {
        if (this.requested.get() < this.sampleSize.get()) {
            return true;
        }
        return this.getSuccessRate() > 60.0;
    }

    public boolean isSuccessRateGreat() {
        if (this.requested.get() < this.sampleSize.get()) {
            return true;
        }
        return this.getSuccessRate() > 80.0;
    }

    public boolean isSuccessRateTerrible() {
        if (this.requested.get() < this.sampleSize.get()) {
            return false;
        }
        return this.getSuccessRate() < 40.0;
    }

    public boolean isOOBEffectiveForProxy() {
        return this.sent.get() <= 40 || this.requested.get() != 0;
    }

    public boolean isOOBEffectiveForMe() {
        return this.sent.get() <= 20 || this.requested.get() != 0;
    }
}

