/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import com.limegroup.gnutella.uploader.UploadSlotUser;
import java.net.InetAddress;
import org.limewire.http.HttpIOSession;

public class HTTPUploadSession
extends BandwidthTrackerImpl
implements UploadSlotUser {
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private HTTPUploader uploader;
    private final InetAddress host;
    private final UploadSlotManager slotManager;
    private volatile long lastPollTime;
    private HTTPUploadSessionManager.QueueStatus queueStatus = HTTPUploadSessionManager.QueueStatus.UNKNOWN;
    private HttpIOSession ioSession;

    public HTTPUploadSession(UploadSlotManager uploadSlotManager, InetAddress inetAddress, HttpIOSession httpIOSession) {
        this.slotManager = uploadSlotManager;
        this.host = inetAddress;
        this.ioSession = httpIOSession;
    }

    public void setUploader(HTTPUploader hTTPUploader) {
        this.uploader = hTTPUploader;
    }

    public HTTPUploader getUploader() {
        return this.uploader;
    }

    int positionInQueue() {
        return this.slotManager.positionInQueue(this);
    }

    public String getHost() {
        return this.host.getHostAddress();
    }

    public InetAddress getConnectedHost() {
        return this.host;
    }

    public boolean poll() {
        long l = System.currentTimeMillis();
        return this.lastPollTime + 45000L > l;
    }

    public void releaseSlot() {
        throw new UnsupportedOperationException();
    }

    public void measureBandwidth() {
        HTTPUploader hTTPUploader = this.getUploader();
        if (hTTPUploader != null) {
            hTTPUploader.measureBandwidth();
        }
    }

    public HTTPUploadSessionManager.QueueStatus getQueueStatus() {
        return this.queueStatus;
    }

    public void setQueueStatus(HTTPUploadSessionManager.QueueStatus queueStatus) {
        this.queueStatus = queueStatus;
        this.updatePollTime(queueStatus);
    }

    public boolean canUpload() {
        return this.queueStatus == HTTPUploadSessionManager.QueueStatus.ACCEPTED || this.queueStatus == HTTPUploadSessionManager.QueueStatus.BYPASS;
    }

    public boolean isAccepted() {
        return this.queueStatus == HTTPUploadSessionManager.QueueStatus.ACCEPTED;
    }

    public boolean isQueued() {
        return this.queueStatus == HTTPUploadSessionManager.QueueStatus.QUEUED;
    }

    public void updatePollTime(HTTPUploadSessionManager.QueueStatus queueStatus) {
        if (queueStatus == HTTPUploadSessionManager.QueueStatus.ACCEPTED || queueStatus == HTTPUploadSessionManager.QueueStatus.BYPASS) {
            this.lastPollTime = 0L;
        } else if (queueStatus == HTTPUploadSessionManager.QueueStatus.QUEUED) {
            this.lastPollTime = System.currentTimeMillis();
        }
    }

    public HttpIOSession getIOSession() {
        return this.ioSession;
    }

    public String toString() {
        return this.getClass().getName() + "[host=" + this.getHost() + ",queueStatus=" + (Object)((Object)this.queueStatus) + "]";
    }
}

