/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.AltLocTracker;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.uploader.AbstractUploader;
import com.limegroup.gnutella.uploader.HTTPUploadSession;
import java.io.File;
import java.net.InetAddress;
import org.apache.http.HttpResponse;
import org.limewire.collection.Range;

public class HTTPUploader
extends AbstractUploader
implements Uploader {
    private URN requestedURN;
    private boolean supportsQueueing = false;
    private AltLocTracker altLocTracker;
    private long uploadBegin;
    private long uploadEnd;
    private boolean containedRangeRequest;
    private long startTime = -1L;
    private boolean visible;
    private String method;
    private HttpResponse lastResponse;
    private PushEndpoint pushEndpoint;

    public HTTPUploader(String string, HTTPUploadSession hTTPUploadSession) {
        super(string, hTTPUploadSession, null);
    }

    public HTTPUploader(String string, HTTPUploadSession hTTPUploadSession, TcpBandwidthStatistics tcpBandwidthStatistics) {
        super(string, hTTPUploadSession, tcpBandwidthStatistics);
    }

    public void reinitialize() {
        super.reinitialize();
        this.requestedURN = null;
        this.uploadBegin = 0L;
        this.uploadEnd = 0L;
        this.containedRangeRequest = false;
        this.method = null;
    }

    public void setFileDesc(FileDesc fileDesc) {
        super.setFileDesc(fileDesc);
        this.setUploadBegin(0L);
        this.setUploadEnd(this.getFileSize());
    }

    public void setFile(File file) {
        this.setFileSize(file.length());
        this.setUploadBegin(0L);
        this.setUploadEnd(this.getFileSize());
    }

    public InetAddress getConnectedHost() {
        return this.getSession().getConnectedHost();
    }

    public void stop() {
        if (this.getSession().getIOSession() != null) {
            this.getSession().getIOSession().shutdown();
        }
    }

    public long getUploadBegin() {
        return this.uploadBegin;
    }

    public long getUploadEnd() {
        return this.uploadEnd;
    }

    public boolean containedRangeRequest() {
        return this.containedRangeRequest;
    }

    public boolean validateRange() {
        long l;
        long l2 = this.getUploadBegin();
        if (l2 >= (l = this.getUploadEnd())) {
            return false;
        }
        if (this.getFileDesc() instanceof IncompleteFileDesc) {
            IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)this.getFileDesc();
            if (this.containedRangeRequest()) {
                Range range = incompleteFileDesc.getAvailableSubRange(l2, l - 1L);
                if (range == null) {
                    return false;
                }
                this.setUploadBegin(range.getLow());
                this.setUploadEnd(range.getHigh() + 1L);
            } else if (!incompleteFileDesc.isRangeSatisfiable(l2, l - 1L)) {
                return false;
            }
        } else if (l2 < 0L || l > this.getFileSize()) {
            return false;
        }
        return true;
    }

    public URN getRequestedURN() {
        return this.requestedURN;
    }

    public void setRequestedURN(URN uRN) {
        this.requestedURN = uRN;
    }

    public boolean supportsQueueing() {
        return this.supportsQueueing && this.isValidQueueingAgent();
    }

    private boolean isValidQueueingAgent() {
        if (this.getUserAgent() == null) {
            return true;
        }
        return !this.getUserAgent().startsWith("Morpheus 3.0.2");
    }

    public void setSupportsQueueing(boolean bl) {
        this.supportsQueueing = bl;
    }

    public AltLocTracker getAltLocTracker() {
        if (this.altLocTracker == null) {
            this.altLocTracker = new AltLocTracker(this.getFileDesc().getSHA1Urn());
        }
        return this.altLocTracker;
    }

    public void setUploadBegin(long l) {
        this.uploadBegin = l;
    }

    public void setUploadEnd(long l) {
        this.uploadEnd = l;
    }

    public void setContainedRangeRequest(boolean bl) {
        this.containedRangeRequest = bl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public boolean isPartial() {
        return this.getUploadEnd() - this.getUploadBegin() < this.getFileSize();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setLastResponse(HttpResponse httpResponse) {
        this.lastResponse = httpResponse;
    }

    public HttpResponse getLastResponse() {
        return this.lastResponse;
    }

    public boolean isChatEnabled() {
        return super.isChatEnabled() && this.getGnutellaPort() != -1;
    }

    public boolean isBrowseHostEnabled() {
        return super.isBrowseHostEnabled() && (this.getGnutellaPort() != -1 || this.pushEndpoint != null);
    }

    public void setPushEndpoint(PushEndpoint pushEndpoint) {
        this.pushEndpoint = pushEndpoint;
    }

    public PushEndpoint getPushEndpoint() {
        return this.pushEndpoint;
    }

    public File getFile() {
        FileDesc fileDesc = this.getFileDesc();
        return fileDesc != null ? fileDesc.getFile() : null;
    }

    public URN getUrn() {
        return this.getFileDesc().getSHA1Urn();
    }

    public int getNumUploadConnections() {
        return 1;
    }

    public float getSeedRatio() {
        return -1.0f;
    }
}

