/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCNetworks {
    private Map<Integer, Integer> counts = new HashMap<Integer, Integer>();
    static final Comparator<Map.Entry<Integer, Integer>> CLASS_C_COMPARATOR = new Comparator<Map.Entry<Integer, Integer>>(){

        @Override
        public int compare(Map.Entry<Integer, Integer> entry, Map.Entry<Integer, Integer> entry2) {
            return entry2.getValue().compareTo(entry.getValue());
        }
    };

    public void addAll(Collection<? extends IpPort> collection) {
        for (IpPort ipPort : collection) {
            this.add(ipPort.getInetAddress(), 1);
        }
    }

    public void add(InetAddress inetAddress, int n) {
        this.add(NetworkUtils.getClassC(inetAddress), n);
    }

    public void add(int n, int n2) {
        Integer n3 = this.counts.get(n &= 0xFFFFFF00);
        if (n3 == null) {
            n3 = 0;
        }
        n3 = n3 + n2;
        this.counts.put(n, n3);
    }

    public List<Map.Entry<Integer, Integer>> getTop() {
        ArrayList<Map.Entry<Integer, Integer>> arrayList = new ArrayList<Map.Entry<Integer, Integer>>(this.counts.size());
        arrayList.addAll(this.counts.entrySet());
        Collections.sort(arrayList, CLASS_C_COMPARATOR);
        return arrayList;
    }

    public byte[] getTopInspectable(int n) {
        List<Map.Entry<Integer, Integer>> list = this.getTop();
        n = Math.min(list.size(), n);
        byte[] byArray = new byte[8 * n];
        int n2 = 0;
        for (Map.Entry<Integer, Integer> entry : list) {
            if (n2 == n) break;
            ByteOrder.int2beb((int)entry.getKey(), byArray, n2 * 8);
            ByteOrder.int2beb((int)entry.getValue(), byArray, n2 * 8 + 4);
            ++n2;
        }
        return byArray;
    }

    public Map<Integer, Integer> getMap() {
        return this.counts;
    }

    public void addAll(ClassCNetworks ... classCNetworksArray) {
        for (ClassCNetworks classCNetworks : classCNetworksArray) {
            for (int n : classCNetworks.getMap().keySet()) {
                this.add(n, (int)classCNetworks.getMap().get(n));
            }
        }
    }
}

