/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.Tagged;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LimeWireUtils {
    @InspectablePrimitive(value="limewire version")
    private static final String LIMEWIRE_VERSION = "4.20.3";
    @InspectablePrimitive(value="bittorrent revision")
    public static final String BT_REVISION = "0002";
    private static String testVersion = null;
    private static final boolean betaVersion = true;
    private static final boolean alphaVersion = false;
    private static final int _majorVersionNumber = LimeWireUtils.getMajorVersionNumberInternal("4.20.3");
    private static final int _minorVersionNumber = LimeWireUtils.getMinorVersionNumberInternal("4.20.3");
    private static final int _serviceVersionNumber = LimeWireUtils.getServiceVersionNumberInternal("4.20.3");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final String HTTP_SERVER;
    public static final String LIMEWIRE_PREFS_DIR_NAME = ".frostwire4.20";
    public static final String FROSTWIRE_418_DIR_NAME = ".frostwire4.18";
    @InspectablePrimitive(value="pro")
    private static boolean _isPro;
    private static boolean temporaryDirectoryInUse;

    private LimeWireUtils() {
    }

    public static boolean isBetaRelease() {
        return true;
    }

    public static boolean isAlphaRelease() {
        return false;
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        if (testVersion == null) {
            return LIMEWIRE_VERSION;
        }
        return testVersion;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    public static int getServiceVersionNumber() {
        return _serviceVersionNumber;
    }

    static int getMajorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(0, n);
                return new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    public static boolean isTestingVersion() {
        return LIMEWIRE_VERSION.equals("@version@");
    }

    static int getMinorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(n + 1);
                int n2 = string2.indexOf(".");
                String string3 = string2.substring(0, n2);
                return new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7;
    }

    static int getServiceVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n;
                int n2;
                int n3 = string.indexOf(".");
                int n4 = string.indexOf(".", n3 + 1);
                for (n2 = n = n4 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
                }
                if (n != n2) {
                    String string2 = string.substring(n, n2);
                    return new Integer(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String getVendor() {
        return "LimeWire 4.20.3";
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static File getTemporarySettingsDirectory() throws IOException {
        File file = FileUtils.createTempFile("frostwire4.18", "-temp").getAbsoluteFile();
        File file2 = file.getParentFile();
        file.delete();
        if (!file.exists() && file.mkdir() && file.exists() && file.isDirectory()) {
            return file;
        }
        for (int i = 0; i < 1000; ++i) {
            file = new File(file2, "frostwire4.18-tempdir-" + i);
            if (file.exists() || !file.mkdir() || !file.exists() || !file.isDirectory()) continue;
            return file;
        }
        throw new IOException("temporary directory failed.  parent [" + file2 + "]");
    }

    public static void clearTemporarySettingsDirectories() {
        File file;
        try {
            file = FileUtils.createTempFile("frostwire4.18", "-temp").getAbsoluteFile();
        }
        catch (IOException iOException) {
            return;
        }
        File file2 = file.getParentFile();
        file.delete();
        for (int i = 0; i < 1000; ++i) {
            File file3 = new File(file2, "frostwire4.18-tempdir-" + i);
            if (file3.delete()) continue;
            FileUtils.deleteRecursive(file3);
        }
    }

    public static File getRequestedUserSettingsLocation() {
        File file = CommonUtils.getUserHomeDir();
        if (!OSUtils.isPOSIX() && file != null && file.exists()) {
            FileUtils.setWriteable(file);
        }
        File file2 = new File(file, LIMEWIRE_PREFS_DIR_NAME);
        if (OSUtils.isWindows()) {
            File file3;
            String string = System.getProperty("LIMEWIRE_PREFS_DIR", SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.APPLICATION_DATA));
            if (string != null && string.length() > 0 && ((file3 = new File(string = LimeWireUtils.stripQuotes(string), "FrostWire")).isDirectory() || !file2.exists())) {
                FileUtils.setWriteable(new File(string));
                try {
                    CommonUtils.validateSettingsDirectory(file3);
                    return file3;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
            }
        } else if (OSUtils.isMacOSX()) {
            file2 = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/FrostWire");
        }
        return file2;
    }

    private static String stripQuotes(String string) {
        if (string == null || string.length() <= 2) {
            return string;
        }
        if ((string = string.trim()).startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String addLWInfoToUrl(String string, byte[] byArray) {
        string = string.indexOf(63) == -1 ? string + "?" : string + "&";
        string = string + "guid=" + EncodingUtils.encode(new GUID(byArray).toHexString()) + "&pro=" + LimeWireUtils.isPro() + "&lang=" + EncodingUtils.encode(ApplicationSettings.getLanguage()) + "&lv=" + EncodingUtils.encode(LimeWireUtils.getLimeWireVersion()) + "&jv=" + EncodingUtils.encode(VersionUtils.getJavaVersion()) + "&os=" + EncodingUtils.encode(OSUtils.getOS()) + "&osv=" + EncodingUtils.encode(OSUtils.getOSVersion());
        return string;
    }

    public static boolean isTemporaryDirectoryInUse() {
        return temporaryDirectoryInUse;
    }

    public static boolean hasSettingsLoadSaveFailures() {
        return SettingsFactory.hasLoadSaveFailure();
    }

    public static void setTemporaryDirectoryInUse(boolean bl) {
        temporaryDirectoryInUse = bl;
    }

    public static void resetSettingsLoadSaveFailures() {
        SettingsFactory.resetLoadSaveFailure();
    }

    public static File getLimeWireRootFolder() {
        String string = null;
        if (OSUtils.isWindows()) {
            string = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOCUMENTS);
        }
        if (string == null || "".equals(string)) {
            string = CommonUtils.getUserHomeDir().getPath();
        }
        return new File(string, "FrostWire");
    }

    public static Tagged<String> getArg(Map<String, String> map, String string, String string2) {
        String string3 = map.get(string);
        if (string3 == null || string3.equals("")) {
            return new Tagged<String>("missing.callback.parameter", false);
        }
        String string4 = string3;
        try {
            string4 = URLDecoder.decode(string3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Tagged<String>(string4, true);
    }

    static {
        _isPro = true;
        if (!LIMEWIRE_VERSION.endsWith("Pro")) {
            HTTP_SERVER = "Frosty/4.20.3";
        } else {
            HTTP_SERVER = "Frosty/" + LIMEWIRE_VERSION.substring(0, LIMEWIRE_VERSION.length() - 4) + " (Pro)";
            _isPro = true;
        }
    }
}

