/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.OS;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCollectionImpl
implements UpdateCollection {
    private static final Log LOG = LogFactory.getLog(UpdateCollectionImpl.class);
    private int collectionId = Integer.MIN_VALUE;
    private long collectionTimestamp = -1L;
    private List<UpdateData> updateDataList = new LinkedList<UpdateData>();
    private List<DownloadInformation> downloadDataList = new LinkedList<DownloadInformation>();
    private final ApplicationServices applicationServices;

    UpdateCollectionImpl(String string, ApplicationServices applicationServices) {
        this.applicationServices = applicationServices;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing Update XML: " + string);
        }
        this.parse(string);
    }

    public String toString() {
        return "Update Collection, id: " + this.collectionId + ", timestamp: " + this.collectionTimestamp + ", data: " + this.updateDataList;
    }

    @Override
    public int getId() {
        return this.collectionId;
    }

    @Override
    public long getTimestamp() {
        return this.collectionTimestamp;
    }

    @Override
    public List<UpdateData> getUpdateData() {
        return this.updateDataList;
    }

    @Override
    public List<DownloadInformation> getUpdatesWithDownloadInformation() {
        return Collections.unmodifiableList(this.downloadDataList);
    }

    @Override
    public UpdateData getUpdateDataFor(Version version, String string, boolean bl, int n, Version version2) {
        UpdateData updateData = null;
        UpdateData updateData2 = null;
        for (UpdateData updateData3 : this.updateDataList) {
            if (!updateData3.isAllowed(version, bl, n, version2)) continue;
            if (string.equals(updateData3.getLanguage())) {
                updateData2 = updateData3;
                break;
            }
            if (!"en".equals(updateData3.getLanguage()) || updateData != null) continue;
            updateData = updateData3;
        }
        if (updateData2 == null) {
            return updateData;
        }
        return updateData2;
    }

    private void parse(String string) {
        Document document;
        try {
            document = XMLUtils.getDocument(string, LOG);
        }
        catch (IOException iOException) {
            LOG.error("Unable to parse: " + string, iOException);
            return;
        }
        this.parseDocumentElement(document.getDocumentElement());
    }

    private void parseDocumentElement(Node node) {
        if (!"update".equals(node.getNodeName())) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getAttributeText(namedNodeMap, "id");
        if (string == null) {
            LOG.error("No id attribute.");
            return;
        }
        try {
            this.collectionId = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Couldn't get collection id from: " + string, numberFormatException);
            return;
        }
        String string2 = this.getAttributeText(namedNodeMap, "timestamp");
        if (string2 != null) {
            try {
                this.collectionTimestamp = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Couldn't get timestamp from: " + string2, numberFormatException);
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"msg".equals(node2.getNodeName())) continue;
            this.parseMsgItem(node2);
        }
    }

    private void parseMsgItem(Node node) {
        Object object;
        UpdateData updateData = new UpdateData();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getAttributeText(namedNodeMap, "from");
        String string2 = this.getAttributeText(namedNodeMap, "to");
        String string3 = this.getAttributeText(namedNodeMap, "for");
        String string4 = this.getAttributeText(namedNodeMap, "pro");
        String string5 = this.getAttributeText(namedNodeMap, "free");
        String string6 = this.getAttributeText(namedNodeMap, "url");
        String string7 = this.getAttributeText(namedNodeMap, "style");
        String string8 = this.getAttributeText(namedNodeMap, "javafrom");
        String string9 = this.getAttributeText(namedNodeMap, "javato");
        String string10 = this.getAttributeText(namedNodeMap, "os");
        String string11 = this.getAttributeText(namedNodeMap, "osv");
        String string12 = this.getAttributeText(namedNodeMap, "urn");
        String string13 = this.getAttributeText(namedNodeMap, "ucommand");
        String string14 = this.getAttributeText(namedNodeMap, "uname");
        String string15 = this.getAttributeText(namedNodeMap, "size");
        if (string12 != null) {
            try {
                object = URN.createSHA1Urn(string12);
                String string16 = URN.getTigerTreeRoot(string12);
                updateData.setUpdateURN((URN)object);
                updateData.setUpdateTTRoot(string16);
            }
            catch (IOException iOException) {
                LOG.warn("Invalid bitprint urn: " + string12, iOException);
            }
        }
        updateData.setUpdateCommand(string13);
        updateData.setUpdateFileName(string14);
        if (string15 != null) {
            try {
                updateData.setUpdateSize(Integer.parseInt(string15));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Invalid size: " + string15);
            }
        }
        if (updateData.getUpdateURN() != null && updateData.getUpdateFileName() != null && updateData.getSize() != 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding new download data item: " + updateData);
            }
            this.downloadDataList.add(updateData);
        }
        if (string3 == null || string6 == null || string7 == null) {
            LOG.error("Missing required for, url, or style.");
            return;
        }
        if (string == null) {
            string = "0.0.0";
        }
        if (string2 == null) {
            string2 = string3;
        }
        try {
            updateData.setFromVersion(new Version(string));
            updateData.setToVersion(new Version(string2));
            updateData.setForVersion(new Version(string3));
            if (string8 != null) {
                updateData.setFromJava(new Version(string8));
            }
            if (string9 != null) {
                updateData.setToJava(new Version(string9));
            }
        }
        catch (VersionFormatException versionFormatException) {
            LOG.error("Invalid version", versionFormatException);
            return;
        }
        if (string4 == null && string5 == null) {
            updateData.setPro(true);
            updateData.setFree(true);
        } else {
            updateData.setPro(string4 != null);
            updateData.setFree(string5 != null);
        }
        string6 = LimeWireUtils.addLWInfoToUrl(string6, this.applicationServices.getMyGUID());
        updateData.setUpdateURL(string6);
        try {
            updateData.setStyle(Integer.parseInt(string7));
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Invalid style", numberFormatException);
            return;
        }
        if (string10 == null) {
            string10 = "*";
        }
        updateData.setOSList(OS.createFromList(string10, string11));
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            if (!"lang".equals(node2.getNodeName())) continue;
            this.parseLangItem((UpdateData)updateData.clone(), node2);
        }
    }

    private void parseLangItem(UpdateData updateData, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getAttributeText(namedNodeMap, "id");
        String string2 = this.getAttributeText(namedNodeMap, "button1");
        String string3 = this.getAttributeText(namedNodeMap, "button2");
        String string4 = this.getAttributeText(namedNodeMap, "title");
        String string5 = LimeXMLUtils.getTextContent(node);
        if (string == null || string5 == null || string5.equals("")) {
            LOG.error("Missing id or message.");
            return;
        }
        updateData.setLanguage(string);
        updateData.setButton1Text(string2);
        updateData.setButton2Text(string3);
        updateData.setUpdateText(string5);
        updateData.setUpdateTitle(string4);
        this.updateDataList.add(updateData);
    }

    private String getAttributeText(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }
}

