/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.version.OS;
import com.limegroup.gnutella.version.UpdateInformation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Version;

class UpdateData
implements Cloneable,
UpdateInformation {
    private static final Log LOG = LogFactory.getLog(UpdateData.class);
    private volatile Version fromVersion;
    private volatile Version toVersion;
    private volatile Version forVersion;
    private volatile boolean isPro;
    private volatile boolean isFree;
    private volatile String updateURL;
    private volatile int updateStyle;
    private volatile Version fromJava;
    private volatile Version toJava;
    private volatile OS[] osList;
    private volatile String language;
    private volatile String updateText;
    private volatile String button1Text;
    private volatile String button2Text;
    private volatile String updateTitle;
    private volatile URN urn;
    private volatile String ttRoot;
    private volatile String updateCommand;
    private volatile String updateFileName;
    private volatile int size;

    UpdateData() {
    }

    public String toString() {
        return "\n{from: " + this.fromVersion + ", to: " + this.toVersion + ", for: " + this.forVersion + ", pro: " + this.isPro + ", free: " + this.isFree + ", url: " + this.updateURL + ", style: " + this.updateStyle + ", javaFrom: " + this.fromJava + ", javaTo: " + this.toJava + ", osList: " + OS.toString(this.osList) + ", language: " + this.language + ", text: " + this.updateText + ", title: " + this.updateTitle + ", urn: " + this.urn + ", ttroot: " + this.ttRoot + ", updateCommand: " + this.updateCommand + ", updateFileName: " + this.updateFileName + ", size: " + this.size + "}";
    }

    void setFromVersion(Version version) {
        this.fromVersion = version;
    }

    void setToVersion(Version version) {
        this.toVersion = version;
    }

    void setForVersion(Version version) {
        this.forVersion = version;
    }

    void setPro(boolean bl) {
        this.isPro = bl;
    }

    void setFree(boolean bl) {
        this.isFree = bl;
    }

    void setUpdateURL(String string) {
        this.updateURL = string;
    }

    void setStyle(int n) {
        this.updateStyle = n;
    }

    void setFromJava(Version version) {
        this.fromJava = version;
    }

    void setToJava(Version version) {
        this.toJava = version;
    }

    void setOSList(OS[] oSArray) {
        this.osList = oSArray;
    }

    void setLanguage(String string) {
        this.language = string;
    }

    void setUpdateText(String string) {
        this.updateText = string;
    }

    void setButton1Text(String string) {
        this.button1Text = string;
    }

    void setButton2Text(String string) {
        this.button2Text = string;
    }

    void setUpdateTitle(String string) {
        this.updateTitle = string;
    }

    void setUpdateURN(URN uRN) {
        this.urn = uRN;
    }

    void setUpdateTTRoot(String string) {
        this.ttRoot = string;
    }

    void setUpdateCommand(String string) {
        this.updateCommand = string;
    }

    void setUpdateFileName(String string) {
        this.updateFileName = string;
    }

    void setUpdateSize(int n) {
        this.size = n;
    }

    String getLanguage() {
        return this.language;
    }

    public String getUpdateVersion() {
        return this.forVersion.toString();
    }

    public String getUpdateText() {
        return this.updateText;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public int getUpdateStyle() {
        return this.updateStyle;
    }

    public String getButton1Text() {
        return this.button1Text;
    }

    public String getButton2Text() {
        return this.button2Text;
    }

    public String getUpdateTitle() {
        return this.updateTitle;
    }

    public String getUpdateFileName() {
        return this.updateFileName;
    }

    public String getUpdateCommand() {
        return this.updateCommand;
    }

    public URN getUpdateURN() {
        return this.urn;
    }

    public String getTTRoot() {
        return this.ttRoot;
    }

    public long getSize() {
        return this.size;
    }

    boolean isAllowed(Version version, boolean bl, int n, Version version2) {
        return version.compareTo(this.fromVersion) >= 0 && version.compareTo(this.toVersion) < 0 && n <= this.updateStyle && OS.hasAcceptableOS(this.osList) && this.isValidJava(version2) && (bl ? this.isPro : this.isFree);
    }

    boolean isValidJava(Version version) {
        if (version == null || this.fromJava == null && this.toJava == null) {
            return true;
        }
        if (this.fromJava == null) {
            return version.compareTo(this.toJava) < 0;
        }
        if (this.toJava == null) {
            return version.compareTo(this.fromJava) >= 0;
        }
        return version.compareTo(this.fromJava) >= 0 && version.compareTo(this.toJava) < 0;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOG.error("shoulda cloned", cloneNotSupportedException);
        }
        return object;
    }
}

